/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.util.placeholder.support;

import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.Assert;
import io.basc.framework.util.StringUtils;
import io.basc.framework.util.placeholder.PlaceholderReplacer;
import io.basc.framework.util.placeholder.PlaceholderResolver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SmartPlaceholderReplacer
implements PlaceholderReplacer {
    private static final Logger logger = LoggerFactory.getLogger(SmartPlaceholderReplacer.class);
    private static final String VALUE_SEPARATOR = ":";
    private static final Map<String, String> wellKnownSimplePrefixes = new HashMap<String, String>(4);
    public static final PlaceholderReplacer STRICT_REPLACER;
    public static final PlaceholderReplacer NON_STRICT_REPLACER;
    private final String placeholderPrefix;
    private final String placeholderSuffix;
    private final String simplePrefix;
    private final String valueSeparator;
    private final boolean ignoreUnresolvablePlaceholders;

    public SmartPlaceholderReplacer(String placeholderPrefix, String placeholderSuffix) {
        this(placeholderPrefix, placeholderSuffix, null, true);
    }

    public SmartPlaceholderReplacer(String placeholderPrefix, String placeholderSuffix, boolean ignoreUnresolvablePlaceholders) {
        this(placeholderPrefix, placeholderSuffix, VALUE_SEPARATOR, ignoreUnresolvablePlaceholders);
    }

    public SmartPlaceholderReplacer(String placeholderPrefix, String placeholderSuffix, String valueSeparator, boolean ignoreUnresolvablePlaceholders) {
        Assert.notNull((Object)placeholderPrefix, "placeholderPrefix must not be null");
        Assert.notNull((Object)placeholderSuffix, "placeholderSuffix must not be null");
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
        String simplePrefixForSuffix = wellKnownSimplePrefixes.get(this.placeholderSuffix);
        this.simplePrefix = simplePrefixForSuffix != null && this.placeholderPrefix.endsWith(simplePrefixForSuffix) ? simplePrefixForSuffix : this.placeholderPrefix;
        this.valueSeparator = valueSeparator;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    @Override
    public String replacePlaceholders(String value, PlaceholderResolver placeholderResolver) {
        Assert.notNull((Object)value, "Argument 'value' must not be null.");
        return this.parseStringValue(value, placeholderResolver, new HashSet<String>(), this.ignoreUnresolvablePlaceholders);
    }

    @Override
    public String replaceRequiredPlaceholders(String value, PlaceholderResolver placeholderResolver) throws IllegalArgumentException {
        Assert.notNull((Object)value, "Argument 'value' must not be null.");
        return this.parseStringValue(value, placeholderResolver, new HashSet<String>(), false);
    }

    protected String parseStringValue(String strVal, PlaceholderResolver placeholderResolver, Set<String> visitedPlaceholders, boolean ignoreUnresolvablePlaceholders) {
        StringBuilder buf = new StringBuilder(strVal);
        int startIndex = strVal.indexOf(this.placeholderPrefix);
        while (startIndex != -1) {
            int endIndex = this.findPlaceholderEndIndex(buf, startIndex);
            if (endIndex != -1) {
                int separatorIndex;
                String placeholder = buf.substring(startIndex + this.placeholderPrefix.length(), endIndex);
                String originalPlaceholder = placeholder;
                if (!visitedPlaceholders.add(originalPlaceholder)) {
                    throw new IllegalArgumentException("Circular placeholder reference '" + originalPlaceholder + "' in property definitions");
                }
                String propVal = placeholderResolver.resolvePlaceholder(placeholder = this.parseStringValue(placeholder, placeholderResolver, visitedPlaceholders, ignoreUnresolvablePlaceholders));
                if (propVal == null && this.valueSeparator != null && (separatorIndex = placeholder.indexOf(this.valueSeparator)) != -1) {
                    String actualPlaceholder = placeholder.substring(0, separatorIndex);
                    String defaultValue = placeholder.substring(separatorIndex + this.valueSeparator.length());
                    propVal = placeholderResolver.resolvePlaceholder(actualPlaceholder);
                    if (propVal == null) {
                        propVal = defaultValue;
                    }
                }
                if (propVal != null) {
                    propVal = this.parseStringValue(propVal, placeholderResolver, visitedPlaceholders, ignoreUnresolvablePlaceholders);
                    buf.replace(startIndex, endIndex + this.placeholderSuffix.length(), propVal);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Resolved placeholder '" + placeholder + "'");
                    }
                    startIndex = buf.indexOf(this.placeholderPrefix, startIndex + propVal.length());
                } else if (ignoreUnresolvablePlaceholders) {
                    startIndex = buf.indexOf(this.placeholderPrefix, endIndex + this.placeholderSuffix.length());
                } else {
                    throw new IllegalArgumentException("Could not resolve placeholder '" + placeholder + "' in string value \"" + strVal + "\"");
                }
                visitedPlaceholders.remove(originalPlaceholder);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    private int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + this.placeholderPrefix.length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            if (StringUtils.substringMatch(buf, index, this.placeholderSuffix)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += this.placeholderSuffix.length();
                    continue;
                }
                return index;
            }
            if (StringUtils.substringMatch(buf, index, this.simplePrefix)) {
                ++withinNestedPlaceholder;
                index += this.simplePrefix.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    static {
        wellKnownSimplePrefixes.put("}", "{");
        wellKnownSimplePrefixes.put("]", "[");
        wellKnownSimplePrefixes.put(")", "(");
        STRICT_REPLACER = new SmartPlaceholderReplacer("${", "}", VALUE_SEPARATOR, false);
        NON_STRICT_REPLACER = new SmartPlaceholderReplacer("${", "}", VALUE_SEPARATOR, true);
    }
}

