/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.value;

import io.basc.framework.event.support.StandardObservable;
import io.basc.framework.util.Registration;
import io.basc.framework.value.Value;
import io.basc.framework.value.ValueFactory;

public class ObservableValue<K>
extends StandardObservable<Value>
implements AutoCloseable {
    private final K key;
    private final ValueFactory<? super K> valueFactory;
    private final Registration registration;

    public ObservableValue(K key, ValueFactory<? super K> valueFactory) {
        this.key = key;
        this.valueFactory = valueFactory;
        this.registration = valueFactory.registerListener(key, e -> this.set(valueFactory.get(key)));
    }

    @Override
    public void close() {
        this.registration.unregister();
    }

    @Override
    protected Value getValue() {
        Value value = (Value)super.getValue();
        return value == null ? this.valueFactory.get(this.key) : value;
    }
}

