/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.value;

import io.basc.framework.event.BroadcastNamedEventDispatcher;
import io.basc.framework.event.ChangeEvent;
import io.basc.framework.event.ChangeType;
import io.basc.framework.event.EventListener;
import io.basc.framework.event.support.StandardBroadcastNamedEventDispatcher;
import io.basc.framework.factory.Configurable;
import io.basc.framework.factory.ConfigurableServices;
import io.basc.framework.factory.ServiceLoaderFactory;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Registration;
import io.basc.framework.util.XUtils;
import io.basc.framework.value.PropertyFactory;
import io.basc.framework.value.Value;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;

public class PropertyFactories
implements PropertyFactory,
Configurable {
    private final BroadcastNamedEventDispatcher<String, ChangeEvent<String>> namedEventDispatcher;
    private final ConfigurableServices<PropertyFactory> factories;

    public PropertyFactories() {
        this(new StandardBroadcastNamedEventDispatcher<String, ChangeEvent<String>>());
    }

    public PropertyFactories(final BroadcastNamedEventDispatcher<String, ChangeEvent<String>> namedEventDispatcher) {
        this.namedEventDispatcher = namedEventDispatcher;
        this.factories = new ConfigurableServices<PropertyFactory>(PropertyFactory.class){

            @Override
            protected boolean addService(PropertyFactory service, Collection<PropertyFactory> targetServices) {
                if (super.addService(service, targetServices)) {
                    long t = System.currentTimeMillis();
                    ConsumeProcessor.consumeAll(service.iterator(), e -> namedEventDispatcher.publishEvent(e, new ChangeEvent<String>(t, ChangeType.CREATE, (String)e)));
                    return true;
                }
                return false;
            }
        };
    }

    public ConfigurableServices<PropertyFactory> getFactories() {
        return this.factories;
    }

    @Override
    public boolean isConfigured() {
        return this.factories.isConfigured();
    }

    @Override
    public void configure(ServiceLoaderFactory serviceLoaderFactory) {
        this.factories.configure(serviceLoaderFactory);
    }

    @Override
    public Value get(String key) {
        for (PropertyFactory factory : this.factories) {
            Value value;
            if (factory == null || factory == this || (value = factory.get(key)) == null || !value.isPresent()) continue;
            return value;
        }
        return Value.EMPTY;
    }

    @Override
    public boolean containsKey(String key) {
        for (PropertyFactory factory : this.factories) {
            if (factory == null || factory == this || !factory.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<String> iterator() {
        return this.stream().iterator();
    }

    @Override
    public Stream<String> stream() {
        Stream<String> stream = null;
        for (PropertyFactory factory : this.factories) {
            stream = stream == null ? factory.stream() : Stream.concat(stream, factory.stream());
        }
        return stream == null ? XUtils.emptyStream() : stream.distinct();
    }

    @Override
    public Registration registerListener(String name, EventListener<ChangeEvent<String>> eventListener) {
        return this.namedEventDispatcher.registerListener(name, eventListener);
    }
}

