/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.value;

import io.basc.framework.event.BroadcastNamedEventRegistry;
import io.basc.framework.event.ChangeEvent;
import io.basc.framework.event.EventListener;
import io.basc.framework.event.Observable;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Registration;
import io.basc.framework.value.ObservableValue;
import io.basc.framework.value.Value;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

public interface ValueFactory<K>
extends BroadcastNamedEventRegistry<K, ChangeEvent<K>> {
    public Value get(K var1);

    default public byte getAsByte(K key) {
        Value value = this.get(key);
        return value == null ? (byte)0 : value.getAsByte();
    }

    default public short getAsShort(K key) {
        Value value = this.get(key);
        return value == null ? (short)0 : value.getAsShort();
    }

    default public int getAsInt(K key) {
        Value value = this.get(key);
        return value == null ? 0 : value.getAsInt();
    }

    default public long getAsLong(K key) {
        Value value = this.get(key);
        return value == null ? 0L : value.getAsLong();
    }

    default public boolean getAsBoolean(K key) {
        Value value = this.get(key);
        return value == null ? false : value.getAsBoolean();
    }

    default public float getAsFloat(K key) {
        Value value = this.get(key);
        return value == null ? 0.0f : value.getAsFloat();
    }

    default public double getAsDouble(K key) {
        Value value = this.get(key);
        return value == null ? 0.0 : value.getAsDouble();
    }

    default public char getAsChar(K key) {
        Value value = this.get(key);
        return value == null ? (char)'\u0000' : value.getAsChar();
    }

    @Nullable
    default public String getAsString(K key) {
        Value value = this.get(key);
        return value == null ? null : value.getAsString();
    }

    @Nullable
    default public BigInteger getAsBigInteger(K key) {
        Value value = this.get(key);
        return value == null ? null : value.getAsBigInteger();
    }

    @Nullable
    default public BigDecimal getAsBigDecimal(K key) {
        Value value = this.get(key);
        return value == null ? null : value.getAsBigDecimal();
    }

    @Nullable
    default public Number getAsNumber(K key) {
        Value value = this.get(key);
        return value == null ? (Number)null : (Number)value.getAsNumber();
    }

    @Nullable
    default public Class<?> getAsClass(K key) {
        Value value = this.get(key);
        return value == null ? null : value.getAsClass();
    }

    @Nullable
    default public Enum<?> getAsEnum(K key, Class<?> enumType) {
        Value value = this.get(key);
        return value == null ? null : value.getAsEnum(enumType);
    }

    @Nullable
    default public <T> T getAsObject(K key, Class<? extends T> type) {
        Value value = this.get(key);
        return value == null ? null : (T)value.getAsObject(type);
    }

    @Nullable
    default public Object getAsObject(K key, Type type) {
        Value value = this.get(key);
        return value == null ? null : value.getAsObject(type);
    }

    @Override
    default public Registration registerListener(K name, EventListener<ChangeEvent<K>> eventListener) {
        return Registration.EMPTY;
    }

    default public Observable<Value> getObservable(K key) {
        return new ObservableValue<K>(key, this);
    }
}

