/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.importer;

import io.camunda.connector.runtime.core.error.InvalidInboundConnectorDefinitionException;
import io.camunda.connector.runtime.core.inbound.InboundConnectorDefinitionImpl;
import io.camunda.connector.runtime.core.inbound.correlation.BoundaryEventCorrelationPoint;
import io.camunda.connector.runtime.core.inbound.correlation.MessageCorrelationPoint;
import io.camunda.connector.runtime.core.inbound.correlation.MessageStartEventCorrelationPoint;
import io.camunda.connector.runtime.core.inbound.correlation.ProcessCorrelationPoint;
import io.camunda.connector.runtime.core.inbound.correlation.StartEventCorrelationPoint;
import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.exception.OperateException;
import io.camunda.operate.model.ProcessDefinition;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.Activity;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.BoundaryEvent;
import io.camunda.zeebe.model.bpmn.instance.CatchEvent;
import io.camunda.zeebe.model.bpmn.instance.FlowElement;
import io.camunda.zeebe.model.bpmn.instance.IntermediateCatchEvent;
import io.camunda.zeebe.model.bpmn.instance.Message;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.ReceiveTask;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeProperties;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinitionInspector {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessDefinitionInspector.class);
    private static final List<Class<? extends BaseElement>> INBOUND_ELIGIBLE_TYPES = new ArrayList<Class<? extends BaseElement>>();
    private final CamundaOperateClient operate;

    public ProcessDefinitionInspector(CamundaOperateClient operate) {
        this.operate = operate;
    }

    public List<InboundConnectorDefinitionImpl> findInboundConnectors(ProcessDefinition processDefinition) throws OperateException {
        LOG.debug("Check " + String.valueOf(processDefinition) + " for connectors.");
        BpmnModelInstance modelInstance = this.operate.getProcessDefinitionModel(processDefinition.getKey());
        Optional<Process> processes = modelInstance.getDefinitions().getChildElementsByType(Process.class).stream().filter(p -> p.getId().equals(processDefinition.getBpmnProcessId())).findFirst();
        Map<String, List<InboundConnectorDefinitionImpl>> connectorDefinitions = processes.stream().flatMap(process -> this.inspectBpmnProcess((Process)process, processDefinition).stream()).collect(Collectors.groupingBy(def -> def.processDefinitionKey() + "-" + def.elementId()));
        return connectorDefinitions.entrySet().stream().map(entry -> {
            if (((List)entry.getValue()).size() > 1) {
                LOG.info("Found multiple connector definitions with the same deduplication ID: " + (String)entry.getKey() + ". It will be ignored");
            }
            return (InboundConnectorDefinitionImpl)((List)entry.getValue()).get(0);
        }).collect(Collectors.toList());
    }

    private List<InboundConnectorDefinitionImpl> inspectBpmnProcess(Process process, ProcessDefinition definition) {
        Collection<BaseElement> inboundEligibleElements = this.retrieveEligibleElementsFromProcess(process);
        ArrayList<InboundConnectorDefinitionImpl> discoveredInboundConnectors = new ArrayList<InboundConnectorDefinitionImpl>();
        for (BaseElement element : inboundEligibleElements) {
            Optional<ProcessCorrelationPoint> optionalTarget = this.getCorrelationPointForElement(element, process, definition);
            if (optionalTarget.isEmpty()) continue;
            ProcessCorrelationPoint target = optionalTarget.get();
            Map<String, String> rawProperties = this.getRawProperties(element);
            if (rawProperties == null || !rawProperties.containsKey("inbound.type")) {
                LOG.debug("Not a connector: " + element.getId());
                continue;
            }
            InboundConnectorDefinitionImpl def = new InboundConnectorDefinitionImpl(rawProperties, target, process.getId(), Integer.valueOf(definition.getVersion().intValue()), definition.getKey(), element.getId(), definition.getTenantId());
            discoveredInboundConnectors.add(def);
        }
        return discoveredInboundConnectors;
    }

    private Collection<BaseElement> retrieveEligibleElementsFromProcess(Process process) {
        HashSet<FlowElement> buffer = new HashSet<FlowElement>();
        Collection<FlowElement> allElements = this.collectFlowElements(process.getFlowElements(), buffer);
        HashSet<BaseElement> inboundEligibleElements = new HashSet<BaseElement>();
        for (FlowElement element : allElements) {
            INBOUND_ELIGIBLE_TYPES.forEach(iet -> {
                if (iet.isInstance(element) && this.getRawProperties((BaseElement)element).containsKey("inbound.type")) {
                    inboundEligibleElements.add((BaseElement)element);
                }
            });
        }
        return inboundEligibleElements;
    }

    private Collection<FlowElement> retrieveEligibleElementsFromSubprocess(SubProcess subprocess) {
        HashSet<FlowElement> buffer = new HashSet<FlowElement>();
        Collection processFlowElements = subprocess.getFlowElements();
        return this.collectFlowElements(processFlowElements, buffer);
    }

    private Collection<FlowElement> collectFlowElements(Collection<FlowElement> processFlowElements, Collection<FlowElement> buffer) {
        for (FlowElement element : processFlowElements) {
            if (element instanceof SubProcess) {
                SubProcess subprocess = (SubProcess)element;
                buffer.addAll(this.retrieveEligibleElementsFromSubprocess(subprocess));
                continue;
            }
            buffer.add(element);
        }
        return buffer;
    }

    private Optional<ProcessCorrelationPoint> getCorrelationPointForElement(BaseElement element, Process process, ProcessDefinition definition) {
        try {
            if (element instanceof StartEvent) {
                StartEvent se = (StartEvent)element;
                return this.getCorrelationPointForStartEvent(se, process, definition);
            }
            if (element instanceof IntermediateCatchEvent) {
                IntermediateCatchEvent ice = (IntermediateCatchEvent)element;
                return this.getCorrelationPointForIntermediateCatchEvent(ice);
            }
            if (element instanceof BoundaryEvent) {
                BoundaryEvent be = (BoundaryEvent)element;
                return this.getCorrelationPointForIntermediateBoundaryEvent(be);
            }
            if (element instanceof ReceiveTask) {
                ReceiveTask rt = (ReceiveTask)element;
                return this.getCorrelationPointForReceiveTask(rt);
            }
            LOG.warn("Unsupported Inbound element type: {}, in process definition: {} (Key: {}, Version: {})", new Object[]{element.getClass().getSimpleName(), definition.getName(), definition.getKey(), definition.getVersion()});
        }
        catch (InvalidInboundConnectorDefinitionException e) {
            LOG.warn("Error getting correlation point for {} in process definition: {} (Key: {}, Version: {}): {}", new Object[]{element.getClass().getSimpleName(), definition.getName(), definition.getKey(), definition.getVersion(), e.getMessage(), e});
        }
        return Optional.empty();
    }

    private Optional<ProcessCorrelationPoint> getCorrelationPointForIntermediateCatchEvent(IntermediateCatchEvent intermediateCatchEvent) {
        return this.getCorrelationPointCatchEvent((CatchEvent)intermediateCatchEvent);
    }

    private Optional<ProcessCorrelationPoint> getCorrelationPointForIntermediateBoundaryEvent(BoundaryEvent boundaryEvent) {
        return this.getCorrelationPointCatchEvent((CatchEvent)boundaryEvent);
    }

    private Optional<ProcessCorrelationPoint> getCorrelationPointCatchEvent(CatchEvent catchEvent) {
        MessageCorrelationPoint correlationPoint;
        MessageEventDefinition msgDef = (MessageEventDefinition)catchEvent.getEventDefinitions().stream().filter(def -> def instanceof MessageEventDefinition).findAny().orElseThrow(() -> new InvalidInboundConnectorDefinitionException("Sanity check failed: " + catchEvent.getClass().getSimpleName() + " must contain at least one event definition"));
        String name = msgDef.getMessage().getName();
        String correlationKeyExpression = this.extractRequiredProperty((BaseElement)catchEvent, "correlationKeyExpression");
        String messageIdExpression = this.extractProperty((BaseElement)catchEvent, "messageIdExpression").orElse(null);
        if (BoundaryEvent.class.isAssignableFrom(catchEvent.getClass())) {
            BoundaryEvent boundaryEvent = (BoundaryEvent)catchEvent;
            Activity attachedTo = boundaryEvent.getAttachedTo();
            BoundaryEventCorrelationPoint.Activity activity = new BoundaryEventCorrelationPoint.Activity(attachedTo.getId(), attachedTo.getName());
            correlationPoint = new BoundaryEventCorrelationPoint(name, correlationKeyExpression, messageIdExpression, activity);
        } else {
            correlationPoint = new MessageCorrelationPoint(name, correlationKeyExpression, messageIdExpression);
        }
        return Optional.of(correlationPoint);
    }

    private Optional<ProcessCorrelationPoint> getCorrelationPointForStartEvent(StartEvent startEvent, Process process, ProcessDefinition definition) {
        MessageEventDefinition msgDef = startEvent.getEventDefinitions().stream().filter(def -> def instanceof MessageEventDefinition).findAny().orElse(null);
        if (msgDef != null) {
            String messageIdExpression = this.extractProperty((BaseElement)startEvent, "messageIdExpression").orElse(null);
            String correlationKeyExpression = this.extractProperty((BaseElement)startEvent, "correlationKeyExpression").orElse(null);
            return Optional.of(new MessageStartEventCorrelationPoint(msgDef.getMessage().getName(), messageIdExpression, correlationKeyExpression, process.getId(), definition.getVersion().intValue(), definition.getKey().longValue()));
        }
        return Optional.of(new StartEventCorrelationPoint(process.getId(), definition.getVersion().intValue(), definition.getKey().longValue()));
    }

    private Optional<ProcessCorrelationPoint> getCorrelationPointForReceiveTask(ReceiveTask receiveTask) {
        Message message = receiveTask.getMessage();
        String correlationKeyExpression = this.extractRequiredProperty((BaseElement)receiveTask, "correlationKeyExpression");
        String messageIdExpression = this.extractProperty((BaseElement)receiveTask, "messageIdExpression").orElse(null);
        return Optional.of(new MessageCorrelationPoint(message.getName(), correlationKeyExpression, messageIdExpression));
    }

    private Map<String, String> getRawProperties(BaseElement element) {
        ZeebeProperties zeebeProperties = (ZeebeProperties)element.getSingleExtensionElement(ZeebeProperties.class);
        if (zeebeProperties == null) {
            return Collections.emptyMap();
        }
        return zeebeProperties.getProperties().stream().filter(property -> property.getValue() != null).collect(Collectors.toMap(ZeebeProperty::getName, ZeebeProperty::getValue));
    }

    private String extractRequiredProperty(BaseElement element, String name) {
        return this.extractProperty(element, name).orElseThrow(() -> new InvalidInboundConnectorDefinitionException("Missing required property " + name));
    }

    private Optional<String> extractProperty(BaseElement element, String name) {
        ZeebeProperties zeebeProperties = (ZeebeProperties)element.getSingleExtensionElement(ZeebeProperties.class);
        return Optional.ofNullable(zeebeProperties).map(ZeebeProperties::getProperties).flatMap(props -> props.stream().filter(property -> property.getName().equals(name)).findAny().map(ZeebeProperty::getValue));
    }

    static {
        INBOUND_ELIGIBLE_TYPES.add(StartEvent.class);
        INBOUND_ELIGIBLE_TYPES.add(IntermediateCatchEvent.class);
        INBOUND_ELIGIBLE_TYPES.add(ReceiveTask.class);
        INBOUND_ELIGIBLE_TYPES.add(BoundaryEvent.class);
    }
}

