/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.util.feel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import io.camunda.connector.runtime.util.feel.FeelConnectorFunctionProvider;
import io.camunda.connector.runtime.util.feel.FeelEngineWrapperException;
import java.util.HashMap;
import java.util.Objects;
import org.camunda.feel.FeelEngine;
import org.camunda.feel.context.FunctionProvider;
import org.camunda.feel.impl.JavaValueMapper;
import org.camunda.feel.valuemapper.CustomValueMapper;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.jdk.javaapi.CollectionConverters;
import scala.util.Either;

public class FeelEngineWrapper {
    static final String RESPONSE_MAP_KEY = "response";
    static final String ERROR_CONTEXT_IS_NULL = "Context is null";
    static final TypeReference<java.util.Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<java.util.Map<String, Object>>(){};
    private final FeelEngine feelEngine;
    private final ObjectMapper objectMapper;

    public FeelEngineWrapper() {
        this.feelEngine = new FeelEngine.Builder().customValueMapper((CustomValueMapper)new JavaValueMapper()).functionProvider((FunctionProvider)new FeelConnectorFunctionProvider()).build();
        this.objectMapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$).registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    public FeelEngineWrapper(FeelEngine feelEngine, ObjectMapper objectMapper) {
        this.feelEngine = feelEngine;
        this.objectMapper = objectMapper;
    }

    private static String trimExpression(String expression) {
        String feelExpression = expression.trim();
        if (feelExpression.startsWith("=")) {
            feelExpression = feelExpression.substring(1);
        }
        return feelExpression.trim();
    }

    private static Map<String, Object> toScalaMap(java.util.Map<String, Object> responseMap) {
        HashMap<String, Object> context = new HashMap<String, Object>(responseMap);
        context.put(RESPONSE_MAP_KEY, responseMap);
        return Map.from((IterableOnce)CollectionConverters.asScala(context));
    }

    private java.util.Map<String, Object> ensureVariablesMap(Object variables) {
        try {
            Objects.requireNonNull(variables, ERROR_CONTEXT_IS_NULL);
            return (java.util.Map)this.objectMapper.convertValue(variables, MAP_TYPE_REFERENCE);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("Unable to parse '%s' as context", variables), ex);
        }
    }

    public <T> T evaluate(String expression, Object variables) {
        try {
            return (T)this.evaluateInternal(expression, variables);
        }
        catch (Exception e) {
            throw new FeelEngineWrapperException(e.getMessage(), expression, variables, e);
        }
    }

    public String evaluateToJson(String expression, Object variables) {
        try {
            return this.resultToJson(this.evaluateInternal(expression, variables));
        }
        catch (Exception e) {
            throw new FeelEngineWrapperException(e.getMessage(), expression, variables, e);
        }
    }

    private Object evaluateInternal(String expression, Object variables) {
        java.util.Map<String, Object> variablesAsMap = this.ensureVariablesMap(variables);
        Map<String, Object> variablesAsMapAsScalaMap = FeelEngineWrapper.toScalaMap(variablesAsMap);
        Either result = this.feelEngine.evalExpression(FeelEngineWrapper.trimExpression(expression), variablesAsMapAsScalaMap);
        if (result.isRight()) {
            return result.right().get();
        }
        throw new RuntimeException(((FeelEngine.Failure)result.left().get()).message());
    }

    private String resultToJson(Object result) {
        try {
            return this.objectMapper.writeValueAsString(result);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("The output expression result cannot be parsed as JSON: " + result, e);
        }
    }
}

