/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.util.inbound;

import io.camunda.connector.api.inbound.InboundConnectorExecutable;
import io.camunda.connector.impl.inbound.InboundConnectorConfiguration;
import io.camunda.connector.runtime.util.ConnectorHelper;
import io.camunda.connector.runtime.util.discovery.EnvVarsConnectorDiscovery;
import io.camunda.connector.runtime.util.discovery.SPIConnectorDiscovery;
import io.camunda.connector.runtime.util.inbound.InboundConnectorFactory;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInboundConnectorFactory
implements InboundConnectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInboundConnectorFactory.class);
    private List<InboundConnectorConfiguration> configurations;

    public DefaultInboundConnectorFactory() {
        this.loadConnectorConfigurations();
        if (this.configurations.size() > 0) {
            LOG.debug("Registered inbound connectors: " + this.configurations);
        } else {
            LOG.warn("No inbound connectors discovered");
        }
    }

    @Override
    public List<InboundConnectorConfiguration> getConfigurations() {
        return this.configurations;
    }

    @Override
    public InboundConnectorExecutable getInstance(String type) {
        InboundConnectorConfiguration configuration = this.configurations.stream().filter(config -> config.getType().equals(type)).findFirst().orElseThrow(() -> new NoSuchElementException("Connector " + type + " is not registered"));
        return (InboundConnectorExecutable)ConnectorHelper.instantiateConnector(configuration.getConnectorClass());
    }

    @Override
    public void registerConfiguration(InboundConnectorConfiguration configuration) {
        Optional<InboundConnectorConfiguration> oldConfig = this.configurations.stream().filter(config -> config.getType().equals(configuration.getType())).findAny();
        if (oldConfig.isPresent()) {
            LOG.info("Connector " + oldConfig + " is overridden, new configuration" + configuration);
            this.configurations.remove(oldConfig.get());
        }
        this.configurations.add(configuration);
    }

    @Override
    public void resetConfigurations() {
        this.loadConnectorConfigurations();
    }

    protected void loadConnectorConfigurations() {
        this.configurations = EnvVarsConnectorDiscovery.isInboundConfigured() ? EnvVarsConnectorDiscovery.discoverInbound() : SPIConnectorDiscovery.discoverInbound();
    }
}

