/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.util.inbound;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import io.camunda.connector.api.inbound.InboundConnectorContext;
import io.camunda.connector.api.inbound.InboundConnectorResult;
import io.camunda.connector.api.secret.SecretProvider;
import io.camunda.connector.impl.context.AbstractConnectorContext;
import io.camunda.connector.impl.inbound.InboundConnectorProperties;
import io.camunda.connector.runtime.util.inbound.correlation.InboundCorrelationHandler;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundConnectorContextImpl
extends AbstractConnectorContext
implements InboundConnectorContext {
    private final Logger LOG = LoggerFactory.getLogger(InboundConnectorContextImpl.class);
    private final InboundConnectorProperties properties;
    private final InboundCorrelationHandler correlationHandler;
    private final ObjectMapper objectMapper;
    private final Consumer<Throwable> cancellationCallback;

    public InboundConnectorContextImpl(SecretProvider secretProvider, InboundConnectorProperties properties, InboundCorrelationHandler correlationHandler, Consumer<Throwable> cancellationCallback) {
        super(secretProvider);
        this.correlationHandler = correlationHandler;
        this.properties = properties;
        this.cancellationCallback = cancellationCallback;
        this.objectMapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$).registerModule((Module)new JavaTimeModule()).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public InboundConnectorContextImpl(SecretProvider secretProvider, InboundConnectorProperties properties, InboundCorrelationHandler correlationHandler, ObjectMapper objectMapper, Consumer<Throwable> cancellationCallback) {
        super(secretProvider);
        this.correlationHandler = correlationHandler;
        this.properties = properties;
        this.objectMapper = objectMapper;
        this.cancellationCallback = cancellationCallback;
    }

    public InboundConnectorResult<?> correlate(Object variables) {
        return this.correlationHandler.correlate(this.properties, variables);
    }

    public void cancel(Throwable exception) {
        try {
            this.cancellationCallback.accept(exception);
        }
        catch (Throwable e) {
            this.LOG.error("Failed to deliver the cancellation signal to the runtime", e);
        }
    }

    public InboundConnectorProperties getProperties() {
        return this.properties;
    }

    public <T> T getPropertiesAsType(Class<T> cls) {
        return (T)this.objectMapper.convertValue((Object)this.properties.getPropertiesAsObjectMap(), cls);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        InboundConnectorContextImpl that = (InboundConnectorContextImpl)((Object)o);
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public String toString() {
        return "InboundConnectorContextImpl{properties=" + this.properties + "}";
    }
}

