/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.util.outbound;

import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.impl.outbound.OutboundConnectorConfiguration;
import io.camunda.connector.runtime.util.ConnectorHelper;
import io.camunda.connector.runtime.util.discovery.EnvVarsConnectorDiscovery;
import io.camunda.connector.runtime.util.discovery.SPIConnectorDiscovery;
import io.camunda.connector.runtime.util.outbound.OutboundConnectorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOutboundConnectorFactory
implements OutboundConnectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOutboundConnectorFactory.class);
    private Map<OutboundConnectorConfiguration, OutboundConnectorFunction> functionMap;

    public DefaultOutboundConnectorFactory() {
        this.loadConnectorConfigurations();
        if (this.functionMap.size() > 0) {
            LOG.debug("Registered outbound connectors: " + this.functionMap.keySet());
        } else {
            LOG.warn("No outbound connectors discovered");
        }
    }

    @Override
    public List<OutboundConnectorConfiguration> getConfigurations() {
        return new ArrayList<OutboundConnectorConfiguration>(this.functionMap.keySet());
    }

    @Override
    public OutboundConnectorFunction getInstance(String type) {
        OutboundConnectorConfiguration configuration = this.functionMap.keySet().stream().filter(config -> config.getType().equals(type)).findFirst().orElseThrow(() -> new NoSuchElementException("Connector " + type + " is not registered"));
        return this.functionMap.get(configuration);
    }

    @Override
    public void registerConfiguration(OutboundConnectorConfiguration configuration) {
        Optional<OutboundConnectorConfiguration> oldConfig = this.functionMap.keySet().stream().filter(config -> config.getType().equals(configuration.getType())).findAny();
        if (oldConfig.isPresent()) {
            LOG.info("Connector " + oldConfig + " is overridden, new configuration" + configuration);
            this.functionMap.remove(oldConfig.get());
        }
        this.functionMap.put(configuration, (OutboundConnectorFunction)ConnectorHelper.instantiateConnector(configuration.getConnectorClass()));
    }

    @Override
    public void resetConfigurations() {
        this.loadConnectorConfigurations();
    }

    protected void loadConnectorConfigurations() {
        List<OutboundConnectorConfiguration> configurations = EnvVarsConnectorDiscovery.isOutboundConfigured() ? EnvVarsConnectorDiscovery.discoverOutbound() : SPIConnectorDiscovery.discoverOutbound();
        this.functionMap = configurations.stream().collect(Collectors.toMap(config -> config, config -> (OutboundConnectorFunction)ConnectorHelper.instantiateConnector(config.getConnectorClass())));
    }
}

