/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime;

import io.camunda.connector.runtime.OperateHealthIndicator;
import io.camunda.connector.runtime.ZeebeHealthIndicator;
import io.camunda.connector.runtime.inbound.importer.ProcessDefinitionImporter;
import io.camunda.connector.runtime.metrics.ContextAwareLogbackMetrics;
import io.camunda.zeebe.client.ZeebeClient;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.LogbackMetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@AutoConfigureBefore(value={LogbackMetricsAutoConfiguration.class})
public class ConnectorsObservabilityAutoConfiguration {
    @Bean
    @ConditionalOnClass(name={"ch.qos.logback.classic.LoggerContext"})
    public LogbackMetrics logbackMetrics() {
        return new ContextAwareLogbackMetrics();
    }

    @Bean(name={"zeebeClientHealthIndicator"})
    public ZeebeHealthIndicator zeebeClientHealthIndicator(ZeebeClient zeebeClient) {
        return new ZeebeHealthIndicator(zeebeClient);
    }

    @Bean
    public OperateHealthIndicator operateHealthIndicator(@Autowired(required=false) ProcessDefinitionImporter processDefinitionImporter) {
        return new OperateHealthIndicator(processDefinitionImporter);
    }
}

