/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.authentication;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;

/**
 * User info data class. An object of this class can be serialized and stored in a session.
 * It is possible that some data might be empty if a user did not provide it or when
 * a service account was used for authentication.
 */
public class UserDetails implements Serializable {
  private static final long serialVersionUID = 15047590002576681L;
  private final String id;
  private final Optional<String> email;
  private final Optional<String> username;
  private final Optional<String> name;

  @Deprecated(since = "8.5", forRemoval = true)
  private final List<String> groups;

  public UserDetails(
      final String id,
      final String email,
      final String username,
      final String name,
      final List<String> groups
  ) {
    this.id = id;
    this.email = Optional.ofNullable(email);
    this.username = Optional.ofNullable(username);
    this.name = Optional.ofNullable(name);
    this.groups = groups;
  }

  public String getId() {
    return id;
  }

  public Optional<String> getEmail() {
    return email;
  }

  public Optional<String> getUsername() {
    return username;
  }

  public Optional<String> getName() {
    return name;
  }

  /**
   * @deprecated  As of release 8.5, replaced by {@link Authentication#getGroups(String)}  }
   */
  @Deprecated(since = "8.5", forRemoval = true)
  public List<String> getGroups() {
    return groups;
  }
}
