/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */

package io.camunda.identity.sdk.impl.rest.request;

import static io.camunda.identity.sdk.authentication.AbstractAuthentication.WELL_KNOWN_PATH;
import static io.camunda.identity.sdk.utility.UrlUtility.combinePaths;

import com.fasterxml.jackson.core.type.TypeReference;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.impl.dto.WellKnownConfiguration;

public class WellKnownRequest extends Request<WellKnownConfiguration> {
  public WellKnownRequest(
      final IdentityConfiguration configuration
  ) {
    super(
        combinePaths(configuration.getIssuerBackendUrl(), WELL_KNOWN_PATH),
        new TypeReference<>() {}
    );
  }
}
