/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.impl;

import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.Authentication;
import io.camunda.identity.sdk.impl.rest.RestClient;
import io.camunda.identity.sdk.impl.rest.request.UsersRequest;
import io.camunda.identity.sdk.users.Users;
import io.camunda.identity.sdk.users.dto.User;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class UsersImpl
implements Users {
    public static final String USERS_PATH = "/api/users";
    private static final String IDENTITY_AUDIENCE = "camunda-identity-resource-server";
    private static final int BATCH_SIZE = 100;
    private final RestClient restClient;
    private final Authentication authentication;
    private final String accessToken;
    private final IdentityConfiguration identityConfiguration;

    public UsersImpl(IdentityConfiguration identityConfiguration, Authentication authentication) {
        this(identityConfiguration, authentication, null);
    }

    private UsersImpl(IdentityConfiguration identityConfiguration, Authentication authentication, String accessToken) {
        this.identityConfiguration = identityConfiguration;
        this.restClient = new RestClient();
        this.authentication = authentication;
        this.accessToken = accessToken;
    }

    @Override
    public Users withAccessToken(String accessToken) {
        Validate.notNull((Object)accessToken, (String)"access token must not be null", (Object[])new Object[0]);
        return new UsersImpl(this.identityConfiguration, this.authentication, accessToken);
    }

    @Override
    public List<User> search(String search) {
        return this.search(search, null, null);
    }

    @Override
    public List<User> search(String search, Integer page) {
        return this.search(search, page, null);
    }

    @Override
    public List<User> search(String search, Integer page, Integer resultSize) {
        return this.restClient.request(new UsersRequest(this.identityConfiguration.getBaseUrl(), this.accessToken(), search, page, resultSize));
    }

    @Override
    public List<User> get(List<String> userIds) {
        return ListUtils.partition(userIds, (int)100).stream().map(ids -> this.requestUsers(this.accessToken(), (List<String>)ids)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public boolean isAvailable() {
        return StringUtils.isNotBlank((CharSequence)this.identityConfiguration.getBaseUrl()) && IdentityConfiguration.Type.KEYCLOAK.equals((Object)this.identityConfiguration.getType());
    }

    private List<User> requestUsers(String accessToken, List<String> userIds) {
        return this.restClient.request(new UsersRequest(this.identityConfiguration.getBaseUrl(), accessToken, userIds));
    }

    private String accessToken() {
        if (this.accessToken != null) {
            return this.accessToken;
        }
        return this.authentication.requestToken(IDENTITY_AUDIENCE).getAccessToken();
    }
}

