/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.impl;

import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.impl.rest.RestClient;
import io.camunda.identity.sdk.impl.rest.request.TenantRequest;
import io.camunda.identity.sdk.tenants.Tenants;
import io.camunda.identity.sdk.tenants.dto.Tenant;
import io.camunda.identity.sdk.utility.UrlUtility;
import java.util.List;

public class TenantsImpl
implements Tenants {
    static final String TENANTS_PATH = "/api/tenants";
    static final String FOR_TOKEN_PATH = "/for-token";
    private final String baseUrl;
    private final RestClient restClient;

    public TenantsImpl(IdentityConfiguration identityConfiguration) {
        this(identityConfiguration.getBaseUrl());
    }

    private TenantsImpl(String baseUrl) {
        this.baseUrl = baseUrl;
        this.restClient = new RestClient();
    }

    @Override
    public List<Tenant> forToken(String token) {
        return this.restClient.request(new TenantRequest(UrlUtility.combinePaths(this.baseUrl, TENANTS_PATH, FOR_TOKEN_PATH), token));
    }
}

