/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.authentication;

import java.io.Serializable;

/**
 * Authorization tokens data class. An object of this class can be serialized and stored
 * in a session.
 */
public class Tokens implements Serializable {
  private static final long serialVersionUID = -1946956228165719612L;
  private final String accessToken;
  private final String refreshToken;
  private final long expiresIn;
  private final String scope;
  private final String tokenType;

  /**
   * Instantiates a new Tokens object.
   * This method is internal and must not be used outside of the SDK.
   *
   * @param accessToken  the access token
   * @param refreshToken the refresh token
   * @param expiresIn    the expires in
   * @param scope        the scope
   * @param tokenType    the token type
   */
  public Tokens(final String accessToken,
                final String refreshToken,
                final long expiresIn,
                final String scope,
                final String tokenType) {
    this.accessToken = accessToken;
    this.refreshToken = refreshToken;
    this.expiresIn = expiresIn;
    this.scope = scope;
    this.tokenType = tokenType;
  }

  /**
   * Gets access token.
   *
   * @return the access token
   */
  public String getAccessToken() {
    return accessToken;
  }

  /**
   * Gets refresh token.
   *
   * @return the refresh token
   */
  public String getRefreshToken() {
    return refreshToken;
  }

  /**
   * Gets expires in.
   *
   * @return the expires in
   */
  public long getExpiresIn() {
    return expiresIn;
  }

  /**
   * Gets scope.
   *
   * @return the scope
   */
  public String getScope() {
    return scope;
  }

  /**
   * Gets token type.
   *
   * @return the token type
   */
  public String getTokenType() {
    return tokenType;
  }
}
