/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.impl.rest.request;

import com.fasterxml.jackson.core.type.TypeReference;
import io.camunda.identity.sdk.authorizations.dto.Authorization;
import java.util.List;
import java.util.Map;

public class AuthorizationRequest extends Request<List<Authorization>> {
  public AuthorizationRequest(
      final String path,
      final String authentication,
      final Map<String, String> params
  ) {
    super(path, new TypeReference<>() {});

    this.setAuthentication(authentication);
    this.setParams(params);
  }
}
