/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.cache;

import com.auth0.jwt.JWT;
import io.camunda.identity.sdk.authentication.Tokens;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.ehcache.expiry.ExpiryPolicy;

public class ClientTokenCacheExpiryPolicy
implements ExpiryPolicy<String, Tokens> {
    private static final long TOKEN_MIN_VALIDITY_SECONDS = 30L;

    public Duration getExpiryForCreation(String audience, Tokens tokens) {
        Instant tokenExpiry = Instant.ofEpochMilli(JWT.decode((String)tokens.getAccessToken()).getExpiresAt().getTime()).minusSeconds(30L);
        long tokenExpiryDuration = Instant.now().until(tokenExpiry, ChronoUnit.MILLIS);
        return Duration.ofMillis(tokenExpiryDuration);
    }

    public Duration getExpiryForAccess(String s, Supplier<? extends Tokens> supplier) {
        return null;
    }

    public Duration getExpiryForUpdate(String s, Supplier<? extends Tokens> supplier, Tokens tokens) {
        return null;
    }
}

