/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.identity.sdk.authentication;

import com.auth0.jwt.interfaces.DecodedJWT;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.annotation.AnnotationProcessor;
import io.camunda.identity.sdk.annotation.RequiresOAuthCredentials;
import io.camunda.identity.sdk.authentication.AbstractAuthentication;
import io.camunda.identity.sdk.authentication.AccessToken;
import io.camunda.identity.sdk.authentication.AuthorizeUriBuilder;
import io.camunda.identity.sdk.authentication.Tokens;
import io.camunda.identity.sdk.authentication.dto.AuthCodeDto;
import io.camunda.identity.sdk.authentication.exception.CodeExchangeException;
import io.camunda.identity.sdk.impl.auth0.authentication.Auth0Authentication;
import io.camunda.identity.sdk.impl.generic.GenericAuthentication;
import io.camunda.identity.sdk.impl.keycloak.KeycloakAuthentication;
import io.camunda.identity.sdk.impl.microsoft.MicrosoftAuthentication;
import io.camunda.identity.sdk.impl.rest.RestClient;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface Authentication {
    public static Authentication create(IdentityConfiguration configuration) {
        AbstractAuthentication authentication;
        switch (configuration.getType()) {
            case AUTH0: {
                authentication = new Auth0Authentication(configuration, new RestClient());
                break;
            }
            case KEYCLOAK: {
                authentication = new KeycloakAuthentication(configuration, new RestClient());
                break;
            }
            case MICROSOFT: {
                authentication = new MicrosoftAuthentication(configuration, new RestClient());
                break;
            }
            case GENERIC: {
                authentication = new GenericAuthentication(configuration, new RestClient());
                break;
            }
            default: {
                throw new RuntimeException("not implemented");
            }
        }
        return AnnotationProcessor.apply(configuration, Authentication.class, authentication);
    }

    public boolean isAvailable();

    @RequiresOAuthCredentials
    public AuthorizeUriBuilder authorizeUriBuilder(String var1);

    @RequiresOAuthCredentials
    public Tokens exchangeAuthCode(AuthCodeDto var1, String var2) throws CodeExchangeException;

    @RequiresOAuthCredentials
    public Tokens renewToken(String var1);

    @RequiresOAuthCredentials
    public void revokeToken(String var1);

    @RequiresOAuthCredentials
    public Optional<URI> singleSignOut(String var1, String var2);

    @RequiresOAuthCredentials
    public Tokens requestToken(String var1);

    public DecodedJWT decodeJWT(String var1);

    public AccessToken verifyToken(String var1);

    public AccessToken verifyToken(String var1, String var2);

    public AccessToken verifyTokenIgnoringAudience(String var1);

    public boolean isM2MToken(String var1);

    public String getClientId(String var1);

    public DecodedJWT verifyAndDecode(String var1, String var2);

    public Map<String, Set<String>> getAssignedOrganizations(DecodedJWT var1);

    public List<String> getPermissions(String var1);

    public List<String> getPermissions(String var1, String var2);

    public List<String> getGroups(String var1);

    public List<String> getGroups(String var1, String var2);

    public List<String> getGroupsInOrganization(String var1, String var2);

    public List<String> getGroupsInOrganization(String var1, String var2, String var3);
}

