/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.autoconfigure;

import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.IdentityConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(Identity.class)
@EnableConfigurationProperties(IdentityProperties.class)
public class IdentityAutoConfiguration {
  private final IdentityProperties identityProperties;

  IdentityAutoConfiguration(final IdentityProperties identityProperties) {
    this.identityProperties = identityProperties;
  }

  @Bean
  @ConditionalOnMissingBean
  public IdentityConfiguration identityConfiguration() {
    var builder = new IdentityConfiguration.Builder();

    builder.withType(identityProperties.type().name());

    if (identityProperties.baseUrl() != null) {
      builder.withBaseUrl(identityProperties.baseUrl());
    }

    if (identityProperties.audience() != null) {
      builder.withAudience(identityProperties.audience());
    }

    if (identityProperties.issuer() != null) {
      builder.withIssuer(identityProperties.issuer());
    }

    if (identityProperties.issuerBackendUrl() != null) {
      builder.withIssuerBackendUrl(identityProperties.issuerBackendUrl());
    }

    if (identityProperties.clientId() != null) {
      builder.withClientId(identityProperties.clientId());
    }

    if (identityProperties.clientSecret() != null) {
      builder.withClientSecret(identityProperties.clientSecret());
    }

    if (identityProperties.authScopes() != null) {
      builder.withAuthScopes(identityProperties.authScopes());
    }

    return builder.build();
  }

  @Bean
  @ConditionalOnMissingBean
  public Identity identity(final IdentityConfiguration identityConfiguration) {
    return new Identity(identityConfiguration);
  }

}
