/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.jobhandling;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.client.api.worker.JobWorker;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.camunda.zeebe.client.api.worker.JobWorkerMetrics;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.JobHandlerInvokingSpringBeans;
import io.camunda.zeebe.spring.client.jobhandling.parameter.ParameterResolverStrategy;
import io.camunda.zeebe.spring.client.jobhandling.result.ResultProcessorStrategy;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import io.camunda.zeebe.spring.client.metrics.ZeebeClientMetricsBridge;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobWorkerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobWorkerManager.class);
    private final CommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final MetricsRecorder metricsRecorder;
    private final ParameterResolverStrategy parameterResolverStrategy;
    private final ResultProcessorStrategy resultProcessorStrategy;
    private List<JobWorker> openedWorkers = new ArrayList<JobWorker>();
    private final List<ZeebeWorkerValue> workerValues = new ArrayList<ZeebeWorkerValue>();

    public JobWorkerManager(CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, MetricsRecorder metricsRecorder, ParameterResolverStrategy parameterResolverStrategy, ResultProcessorStrategy resultProcessorStrategy) {
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.metricsRecorder = metricsRecorder;
        this.parameterResolverStrategy = parameterResolverStrategy;
        this.resultProcessorStrategy = resultProcessorStrategy;
    }

    public JobWorker openWorker(ZeebeClient client, ZeebeWorkerValue zeebeWorkerValue) {
        return this.openWorker(client, zeebeWorkerValue, new JobHandlerInvokingSpringBeans(zeebeWorkerValue, this.commandExceptionHandlingStrategy, this.metricsRecorder, this.parameterResolverStrategy, this.resultProcessorStrategy));
    }

    public JobWorker openWorker(ZeebeClient client, ZeebeWorkerValue zeebeWorkerValue, JobHandler handler) {
        JobWorkerBuilderStep1.JobWorkerBuilderStep3 builder = client.newWorker().jobType(zeebeWorkerValue.getType()).handler(handler).name(zeebeWorkerValue.getName()).metrics((JobWorkerMetrics)new ZeebeClientMetricsBridge(this.metricsRecorder, zeebeWorkerValue.getType()));
        if (zeebeWorkerValue.getMaxJobsActive() != null && zeebeWorkerValue.getMaxJobsActive() > 0) {
            builder.maxJobsActive(zeebeWorkerValue.getMaxJobsActive().intValue());
        }
        if (this.isValidDuration(zeebeWorkerValue.getTimeout())) {
            builder.timeout(zeebeWorkerValue.getTimeout());
        }
        if (this.isValidDuration(zeebeWorkerValue.getPollInterval())) {
            builder.pollInterval(zeebeWorkerValue.getPollInterval());
        }
        if (this.isValidDuration(zeebeWorkerValue.getRequestTimeout())) {
            builder.requestTimeout(zeebeWorkerValue.getRequestTimeout());
        }
        if (zeebeWorkerValue.getFetchVariables() != null && !zeebeWorkerValue.getFetchVariables().isEmpty()) {
            builder.fetchVariables(zeebeWorkerValue.getFetchVariables());
        }
        if (zeebeWorkerValue.getTenantIds() != null && !zeebeWorkerValue.getTenantIds().isEmpty()) {
            builder.tenantIds(zeebeWorkerValue.getTenantIds());
        }
        if (zeebeWorkerValue.getStreamEnabled() != null) {
            builder.streamEnabled(zeebeWorkerValue.getStreamEnabled().booleanValue());
        }
        if (this.isValidDuration(zeebeWorkerValue.getStreamTimeout())) {
            builder.streamTimeout(zeebeWorkerValue.getStreamTimeout());
        }
        JobWorker jobWorker = builder.open();
        this.openedWorkers.add(jobWorker);
        this.workerValues.add(zeebeWorkerValue);
        LOGGER.info(". Starting Zeebe worker: {}", (Object)zeebeWorkerValue);
        return jobWorker;
    }

    private boolean isValidDuration(Duration duration) {
        return duration != null && !duration.isNegative();
    }

    public void closeAllOpenWorkers() {
        this.openedWorkers.forEach(worker -> worker.close());
        this.openedWorkers = new ArrayList<JobWorker>();
    }

    public void closeWorker(JobWorker worker) {
        worker.close();
        int i = this.openedWorkers.indexOf(worker);
        this.openedWorkers.remove(i);
        this.workerValues.remove(i);
    }

    public Optional<ZeebeWorkerValue> findJobWorkerConfigByName(String name) {
        return this.workerValues.stream().filter(worker -> worker.getName().equals(name)).findFirst();
    }

    public Optional<ZeebeWorkerValue> findJobWorkerConfigByType(String type) {
        return this.workerValues.stream().filter(worker -> worker.getType().equals(type)).findFirst();
    }
}

