/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.jobhandling;

import io.camunda.connector.api.error.BpmnError;
import io.camunda.connector.api.secret.SecretProvider;
import io.camunda.connector.impl.outbound.OutboundConnectorConfiguration;
import io.camunda.connector.runtime.util.outbound.ConnectorJobHandler;
import io.camunda.connector.runtime.util.outbound.ConnectorResult;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.CommandWrapper;
import io.camunda.zeebe.spring.client.jobhandling.JobHandlerInvokingSpringBeans;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;

public class SpringConnectorJobHandler
extends ConnectorJobHandler {
    private final CommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final OutboundConnectorConfiguration connectorConfiguration;
    private final MetricsRecorder metrics;

    public SpringConnectorJobHandler(OutboundConnectorConfiguration connectorConfiguration, SecretProvider secretProvider, CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, MetricsRecorder metrics) {
        super(connectorConfiguration.getFunction(), secretProvider);
        this.connectorConfiguration = connectorConfiguration;
        this.metrics = metrics;
        this.secretProvider = secretProvider;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
    }

    public void handle(JobClient client, ActivatedJob job) {
        this.metrics.increase("camunda.connector.outbound.invocations", "activated", this.connectorConfiguration.getType());
        super.handle(client, job);
    }

    protected void failJob(JobClient client, ActivatedJob job, Exception exception) {
        this.metrics.increase("camunda.connector.outbound.invocations", "failed", this.connectorConfiguration.getType());
        throw new RuntimeException(exception);
    }

    protected void throwBpmnError(JobClient client, ActivatedJob job, BpmnError value) {
        this.metrics.increase("camunda.connector.outbound.invocations", "bpmn-error", this.connectorConfiguration.getType());
        new CommandWrapper((FinalCommandStep<Void>)client.newThrowErrorCommand(job.getKey()).errorCode(value.getCode()).errorMessage(value.getMessage()), job, this.commandExceptionHandlingStrategy).executeAsync();
    }

    protected void completeJob(JobClient client, ActivatedJob job, ConnectorResult result) {
        this.metrics.increase("camunda.connector.outbound.invocations", "completed", this.connectorConfiguration.getType());
        new CommandWrapper((FinalCommandStep<Void>)JobHandlerInvokingSpringBeans.createCompleteCommand(client, job, result.getVariables()), job, this.commandExceptionHandlingStrategy).executeAsync();
    }
}

