/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.common.auth;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.HttpClient;
import io.camunda.common.auth.JwtAuthentication;
import io.camunda.common.auth.JwtConfig;
import io.camunda.common.auth.JwtCredential;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SaaSAuthenticationBuilder;
import io.camunda.common.auth.TokenRequest;
import io.camunda.common.auth.TokenResponse;
import io.camunda.common.json.JsonMapper;
import io.camunda.common.json.SdkObjectMapper;
import java.lang.invoke.MethodHandles;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaaSAuthentication
extends JwtAuthentication {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private JwtConfig jwtConfig;
    private Map<Product, String> tokens;
    private JsonMapper jsonMapper = new SdkObjectMapper();

    public SaaSAuthentication() {
        this.tokens = new HashMap<Product, String>();
    }

    public static SaaSAuthenticationBuilder builder() {
        return new SaaSAuthenticationBuilder();
    }

    public JwtConfig getJwtConfig() {
        return this.jwtConfig;
    }

    public void setJwtConfig(JwtConfig jwtConfig) {
        this.jwtConfig = jwtConfig;
    }

    @Override
    public Authentication build() {
        return this;
    }

    @Override
    public void resetToken(Product product) {
        this.tokens.remove((Object)product);
    }

    private String retrieveToken(Product product, JwtCredential jwtCredential) {
        try {
            HttpPost httpPost = new HttpPost(jwtCredential.getAuthUrl());
            httpPost.addHeader("Content-Type", (Object)"application/json");
            TokenRequest tokenRequest = new TokenRequest(jwtCredential.getAudience(), jwtCredential.getClientId(), jwtCredential.getClientSecret());
            httpPost.setEntity((HttpEntity)new StringEntity(this.jsonMapper.toJson(tokenRequest)));
            CloseableHttpClient client = HttpClient.getInstance();
            CloseableHttpResponse response = client.execute((ClassicHttpRequest)httpPost);
            TokenResponse tokenResponse = this.jsonMapper.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), TokenResponse.class);
            this.tokens.put(product, tokenResponse.getAccessToken());
        }
        catch (Exception e) {
            LOG.error("Authenticating for " + (Object)((Object)product) + " failed due to " + e);
            throw new RuntimeException("Unable to authenticate", e);
        }
        return this.tokens.get((Object)product);
    }

    @Override
    public Map.Entry<String, String> getTokenHeader(Product product) {
        String token;
        if (this.tokens.containsKey((Object)product)) {
            token = this.tokens.get((Object)product);
        } else {
            JwtCredential jwtCredential = this.jwtConfig.getProduct(product);
            token = this.retrieveToken(product, jwtCredential);
        }
        return new AbstractMap.SimpleEntry<String, String>("Authorization", "Bearer " + token);
    }
}

