/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.ZeebeClientImpl;
import io.camunda.zeebe.client.impl.util.ExecutorResource;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.spring.client.configuration.ExecutorServiceConfiguration;
import io.camunda.zeebe.spring.client.configuration.ZeebeActuatorConfiguration;
import io.camunda.zeebe.spring.client.configuration.ZeebeClientAllAutoConfiguration;
import io.camunda.zeebe.spring.client.jobhandling.ZeebeClientExecutorService;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import io.camunda.zeebe.spring.client.testsupport.SpringZeebeTestContext;
import io.grpc.ManagedChannel;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(prefix="zeebe.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnMissingBean(value={SpringZeebeTestContext.class})
@ImportAutoConfiguration(value={ExecutorServiceConfiguration.class, ZeebeActuatorConfiguration.class})
@AutoConfigureBefore(value={ZeebeClientAllAutoConfiguration.class})
public class ZeebeClientProdAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ZeebeClientConfigurationProperties configurationProperties;
    private final ZeebeClientExecutorService zeebeClientExecutorService;

    public ZeebeClientProdAutoConfiguration(ZeebeClientConfigurationProperties configurationProperties, ZeebeClientExecutorService zeebeClientExecutorService, JsonMapper jsonMapper) {
        this.configurationProperties = configurationProperties;
        configurationProperties.setJsonMapper(jsonMapper);
        configurationProperties.setScheduledExecutorService(zeebeClientExecutorService.get());
        configurationProperties.applyOverrides();
        this.zeebeClientExecutorService = zeebeClientExecutorService;
    }

    @Bean(destroyMethod="close")
    public ZeebeClient zeebeClient() {
        LOG.info("Creating ZeebeClient using ZeebeClientConfiguration [" + this.configurationProperties + "]");
        if (this.zeebeClientExecutorService != null) {
            ManagedChannel managedChannel = ZeebeClientImpl.buildChannel((ZeebeClientConfiguration)this.configurationProperties);
            GatewayGrpc.GatewayStub gatewayStub = ZeebeClientImpl.buildGatewayStub((ManagedChannel)managedChannel, (ZeebeClientConfiguration)this.configurationProperties);
            ExecutorResource executorResource = new ExecutorResource(this.zeebeClientExecutorService.get(), this.configurationProperties.ownsJobWorkerExecutor());
            return new ZeebeClientImpl((ZeebeClientConfiguration)this.configurationProperties, managedChannel, gatewayStub, executorResource);
        }
        return new ZeebeClientImpl((ZeebeClientConfiguration)this.configurationProperties);
    }
}

