/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.DefaultNoopAuthentication;
import io.camunda.common.auth.JwtConfig;
import io.camunda.common.auth.JwtCredential;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SaaSAuthentication;
import io.camunda.common.auth.SelfManagedAuthentication;
import io.camunda.common.auth.SimpleAuthentication;
import io.camunda.common.auth.SimpleConfig;
import io.camunda.common.auth.SimpleCredential;
import io.camunda.zeebe.spring.client.properties.CommonConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.ConsoleClientConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.OperateClientConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.OptimizeClientConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.TasklistClientConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.ZeebeSelfManagedProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@EnableConfigurationProperties(value={CommonConfigurationProperties.class, ZeebeSelfManagedProperties.class})
public class CommonClientConfiguration {
    @Autowired(required=false)
    CommonConfigurationProperties commonConfigurationProperties;
    @Autowired(required=false)
    ZeebeClientConfigurationProperties zeebeClientConfigurationProperties;
    @Autowired(required=false)
    ConsoleClientConfigurationProperties consoleClientConfigurationProperties;
    @Autowired(required=false)
    OptimizeClientConfigurationProperties optimizeClientConfigurationProperties;
    @Autowired(required=false)
    TasklistClientConfigurationProperties tasklistClientConfigurationProperties;
    @Autowired(required=false)
    OperateClientConfigurationProperties operateClientConfigurationProperties;
    @Autowired(required=false)
    ZeebeSelfManagedProperties zeebeSelfManagedProperties;

    @Bean
    public Authentication authentication() {
        if (this.zeebeClientConfigurationProperties != null) {
            if (this.zeebeClientConfigurationProperties.getCloud().getClusterId() != null) {
                return SaaSAuthentication.builder().jwtConfig(this.configureJwtConfig()).build();
            }
            if (this.zeebeClientConfigurationProperties.getBroker().getGatewayAddress() != null || this.zeebeSelfManagedProperties.getGatewayAddress() != null) {
                if (this.operateClientConfigurationProperties != null) {
                    if (this.operateClientConfigurationProperties.getKeycloakUrl() != null) {
                        return SelfManagedAuthentication.builder().jwtConfig(this.configureJwtConfig()).keycloakUrl(this.operateClientConfigurationProperties.getKeycloakUrl()).keycloakRealm(this.operateClientConfigurationProperties.getKeycloakRealm()).build();
                    }
                    if (this.operateClientConfigurationProperties.getKeycloakTokenUrl() != null) {
                        return SelfManagedAuthentication.builder().jwtConfig(this.configureJwtConfig()).keycloakTokenUrl(this.operateClientConfigurationProperties.getKeycloakTokenUrl()).build();
                    }
                    if (this.operateClientConfigurationProperties.getUsername() != null && this.operateClientConfigurationProperties.getPassword() != null) {
                        SimpleConfig simpleConfig = new SimpleConfig();
                        SimpleCredential simpleCredential = new SimpleCredential(this.operateClientConfigurationProperties.getUsername(), this.operateClientConfigurationProperties.getPassword());
                        simpleConfig.addProduct(Product.OPERATE, simpleCredential);
                        return SimpleAuthentication.builder().simpleConfig(simpleConfig).simpleUrl(this.operateClientConfigurationProperties.getUrl()).build();
                    }
                }
                if (this.commonConfigurationProperties != null) {
                    if (this.commonConfigurationProperties.getKeycloak().getUrl() != null) {
                        return SelfManagedAuthentication.builder().jwtConfig(this.configureJwtConfig()).keycloakUrl(this.commonConfigurationProperties.getKeycloak().getUrl()).keycloakRealm(this.commonConfigurationProperties.getKeycloak().getRealm()).build();
                    }
                    if (this.commonConfigurationProperties.getKeycloak().getTokenUrl() != null) {
                        return SelfManagedAuthentication.builder().jwtConfig(this.configureJwtConfig()).keycloakTokenUrl(this.commonConfigurationProperties.getKeycloak().getTokenUrl()).build();
                    }
                    if (this.commonConfigurationProperties.getUsername() != null && this.commonConfigurationProperties.getPassword() != null) {
                        SimpleConfig simpleConfig = new SimpleConfig();
                        SimpleCredential simpleCredential = new SimpleCredential(this.commonConfigurationProperties.getUsername(), this.commonConfigurationProperties.getPassword());
                        simpleConfig.addProduct(Product.OPERATE, simpleCredential);
                        return SimpleAuthentication.builder().simpleConfig(simpleConfig).simpleUrl(this.commonConfigurationProperties.getUrl()).build();
                    }
                }
            }
        }
        return new DefaultNoopAuthentication().build();
    }

    private JwtConfig configureJwtConfig() {
        JwtConfig jwtConfig = new JwtConfig();
        if (this.zeebeClientConfigurationProperties.getCloud().getClientId() != null && this.zeebeClientConfigurationProperties.getCloud().getClientSecret() != null) {
            jwtConfig.addProduct(Product.ZEEBE, new JwtCredential(this.zeebeClientConfigurationProperties.getCloud().getClientId(), this.zeebeClientConfigurationProperties.getCloud().getClientSecret(), this.zeebeClientConfigurationProperties.getCloud().getAudience(), this.zeebeClientConfigurationProperties.getCloud().getAuthUrl()));
        } else if (this.zeebeSelfManagedProperties.getClientId() != null && this.zeebeSelfManagedProperties.getClientSecret() != null) {
            jwtConfig.addProduct(Product.ZEEBE, new JwtCredential(this.zeebeSelfManagedProperties.getClientId(), this.zeebeSelfManagedProperties.getClientSecret(), this.zeebeSelfManagedProperties.getAudience(), this.zeebeSelfManagedProperties.getAuthServer()));
        } else if (this.commonConfigurationProperties.getClientId() != null && this.commonConfigurationProperties.getClientSecret() != null) {
            jwtConfig.addProduct(Product.ZEEBE, new JwtCredential(this.commonConfigurationProperties.getClientId(), this.commonConfigurationProperties.getClientSecret(), this.zeebeClientConfigurationProperties.getCloud().getAudience(), this.zeebeClientConfigurationProperties.getCloud().getAuthUrl()));
        }
        String operateAuthUrl = this.zeebeClientConfigurationProperties.getCloud().getAuthUrl();
        String operateAudience = "operate.camunda.io";
        if (this.operateClientConfigurationProperties != null) {
            if (this.operateClientConfigurationProperties.getAuthUrl() != null) {
                operateAuthUrl = this.operateClientConfigurationProperties.getAuthUrl();
            }
            if (this.operateClientConfigurationProperties.getBaseUrl() != null) {
                operateAudience = this.operateClientConfigurationProperties.getBaseUrl();
            }
            if (this.operateClientConfigurationProperties.getClientId() != null && this.operateClientConfigurationProperties.getClientSecret() != null) {
                jwtConfig.addProduct(Product.OPERATE, new JwtCredential(this.operateClientConfigurationProperties.getClientId(), this.operateClientConfigurationProperties.getClientSecret(), operateAudience, operateAuthUrl));
            } else if (this.commonConfigurationProperties.getClientId() != null && this.commonConfigurationProperties.getClientSecret() != null) {
                jwtConfig.addProduct(Product.OPERATE, new JwtCredential(this.commonConfigurationProperties.getClientId(), this.commonConfigurationProperties.getClientSecret(), operateAudience, operateAuthUrl));
            } else if (this.zeebeClientConfigurationProperties.getCloud().getClientId() != null && this.zeebeClientConfigurationProperties.getCloud().getClientSecret() != null) {
                jwtConfig.addProduct(Product.OPERATE, new JwtCredential(this.zeebeClientConfigurationProperties.getCloud().getClientId(), this.zeebeClientConfigurationProperties.getCloud().getClientSecret(), operateAudience, operateAuthUrl));
            } else if (this.zeebeSelfManagedProperties.getClientId() != null && this.zeebeSelfManagedProperties.getClientSecret() != null) {
                jwtConfig.addProduct(Product.OPERATE, new JwtCredential(this.zeebeSelfManagedProperties.getClientId(), this.zeebeSelfManagedProperties.getClientSecret(), operateAudience, operateAuthUrl));
            } else {
                throw new RuntimeException("Unable to determine OPERATE credentials");
            }
        }
        return jwtConfig;
    }
}

