/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.auth.impl;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import io.camunda.zeebe.auth.api.AuthorizationEncoder;
import io.camunda.zeebe.auth.api.JwtAuthorizationBuilder;
import io.camunda.zeebe.util.exception.UnrecoverableException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtAuthorizationEncoder
implements JwtAuthorizationBuilder<JwtAuthorizationEncoder, Algorithm, String>,
AuthorizationEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtAuthorizationEncoder.class);
    private String issuer = "zeebe-gateway";
    private String audience = "zeebe-broker";
    private String subject = "zeebe-client";
    private Algorithm signingAlgorithm = Algorithm.none();
    private final Map<String, Object> claims = new HashMap<String, Object>();

    @Override
    public JwtAuthorizationEncoder withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    @Override
    public JwtAuthorizationEncoder withIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Override
    public JwtAuthorizationEncoder withAudience(String audience) {
        this.audience = audience;
        return this;
    }

    @Override
    public JwtAuthorizationEncoder withSigningAlgorithm(Algorithm signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
        return this;
    }

    @Override
    public String build() {
        try {
            return JWT.create().withIssuer(this.issuer).withAudience(new String[]{this.audience}).withSubject(this.subject).withPayload(this.claims).sign(this.signingAlgorithm);
        }
        catch (JWTCreationException | IllegalArgumentException ex) {
            LOGGER.error("Authorization data couldn't be encoded: {}", (Object)ex.getMessage());
            throw new UnrecoverableException("Authorization data couldn't be encoded: " + ex.getMessage(), ex);
        }
    }

    public JwtAuthorizationEncoder withClaim(String claimName, Object claimValue) {
        this.claims.put(claimName, claimValue);
        return this;
    }

    @Override
    public String encode() {
        return this.build();
    }
}

