/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.response.ProcessInstanceResult;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.Map;

public final class CreateProcessInstanceWithResultResponseImpl
implements ProcessInstanceResult {
    private final JsonMapper jsonMapper;
    private final long processDefinitionKey;
    private final String bpmnProcessId;
    private final int version;
    private final long processInstanceKey;
    private final String variables;

    public CreateProcessInstanceWithResultResponseImpl(JsonMapper jsonMapper, GatewayOuterClass.CreateProcessInstanceWithResultResponse response) {
        this.jsonMapper = jsonMapper;
        this.processDefinitionKey = response.getProcessDefinitionKey();
        this.bpmnProcessId = response.getBpmnProcessId();
        this.version = response.getVersion();
        this.processInstanceKey = response.getProcessInstanceKey();
        this.variables = response.getVariables();
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getVariables() {
        return this.variables;
    }

    @Override
    public Map<String, Object> getVariablesAsMap() {
        return this.jsonMapper.fromJsonAsMap(this.variables);
    }

    @Override
    public <T> T getVariablesAsType(Class<T> variableType) {
        return this.jsonMapper.fromJson(this.variables, variableType);
    }

    public String toString() {
        return "CreateProcessInstanceWithResultResponseImpl{processDefinitionKey=" + this.processDefinitionKey + ", bpmnProcessId='" + this.bpmnProcessId + '\'' + ", version=" + this.version + ", processInstanceKey=" + this.processInstanceKey + ", variables='" + this.variables + '\'' + '}';
    }
}

