/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.command.CreateProcessInstanceWithResultCommandImpl;
import io.camunda.zeebe.client.impl.response.CreateProcessInstanceResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class CreateProcessInstanceCommandImpl
implements CreateProcessInstanceCommandStep1,
CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep2,
CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.CreateProcessInstanceRequest.Builder builder;
    private final Predicate<Throwable> retryPredicate;
    private final JsonMapper jsonMapper;
    private Duration requestTimeout;

    public CreateProcessInstanceCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, Duration requestTimeout, Predicate<Throwable> retryPredicate) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.jsonMapper = jsonMapper;
        this.builder = GatewayOuterClass.CreateProcessInstanceRequest.newBuilder();
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 variables(InputStream variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.jsonMapper.validateJson("variables", variables));
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 variables(String variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.jsonMapper.validateJson("variables", variables));
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 variables(Map<String, Object> variables) {
        return this.variables((Object)variables);
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 variables(Object variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.jsonMapper.toJson(variables));
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 startBeforeElement(String elementId) {
        this.builder.addStartInstructions(GatewayOuterClass.ProcessInstanceCreationStartInstruction.newBuilder().setElementId(elementId).build());
        return this;
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceWithResultCommandStep1 withResult() {
        return new CreateProcessInstanceWithResultCommandImpl(this.jsonMapper, this.asyncStub, this.builder, this.retryPredicate, this.requestTimeout);
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep2 bpmnProcessId(String id) {
        this.builder.setBpmnProcessId(id);
        return this;
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 processDefinitionKey(long processDefinitionKey) {
        this.builder.setProcessDefinitionKey(processDefinitionKey);
        return this;
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 version(int version) {
        this.builder.setVersion(version);
        return this;
    }

    @Override
    public CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 latestVersion() {
        return this.version(-1);
    }

    @Override
    public FinalCommandStep<ProcessInstanceEvent> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<ProcessInstanceEvent> send() {
        GatewayOuterClass.CreateProcessInstanceRequest request = this.builder.build();
        RetriableClientFutureImpl<ProcessInstanceEvent, GatewayOuterClass.CreateProcessInstanceResponse> future = new RetriableClientFutureImpl<ProcessInstanceEvent, GatewayOuterClass.CreateProcessInstanceResponse>(CreateProcessInstanceResponseImpl::new, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.CreateProcessInstanceResponse>)streamObserver));
        this.send(request, future);
        return future;
    }

    private void send(GatewayOuterClass.CreateProcessInstanceRequest request, StreamObserver<GatewayOuterClass.CreateProcessInstanceResponse> future) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).createProcessInstance(request, future);
    }

    private CreateProcessInstanceCommandStep1.CreateProcessInstanceCommandStep3 setVariables(String jsonDocument) {
        this.builder.setVariables(jsonDocument);
        return this;
    }
}

