/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.TopologyRequestStep1;
import io.camunda.zeebe.client.api.response.Topology;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.response.TopologyImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class TopologyRequestImpl
implements TopologyRequestStep1 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final Predicate<Throwable> retryPredicate;
    private Duration requestTimeout;

    public TopologyRequestImpl(GatewayGrpc.GatewayStub asyncStub, Duration requestTimeout, Predicate<Throwable> retryPredicate) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
    }

    @Override
    public FinalCommandStep<Topology> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<Topology> send() {
        GatewayOuterClass.TopologyRequest request = GatewayOuterClass.TopologyRequest.getDefaultInstance();
        RetriableClientFutureImpl<Topology, GatewayOuterClass.TopologyResponse> future = new RetriableClientFutureImpl<Topology, GatewayOuterClass.TopologyResponse>(TopologyImpl::new, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.TopologyResponse>)streamObserver));
        this.send(request, future);
        return future;
    }

    private void send(GatewayOuterClass.TopologyRequest request, StreamObserver<GatewayOuterClass.TopologyResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).topology(request, streamObserver);
    }
}

