/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.EvaluateDecisionCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.EvaluateDecisionResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.response.EvaluateDecisionResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class EvaluateDecisionCommandImpl
implements EvaluateDecisionCommandStep1,
EvaluateDecisionCommandStep1.EvaluateDecisionCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.EvaluateDecisionRequest.Builder builder;
    private final Predicate<Throwable> retryPredicate;
    private final JsonMapper jsonMapper;
    private Duration requestTimeout;

    public EvaluateDecisionCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, Duration requestTimeout, Predicate<Throwable> retryPredicate) {
        this.asyncStub = asyncStub;
        this.retryPredicate = retryPredicate;
        this.jsonMapper = jsonMapper;
        this.requestTimeout = requestTimeout;
        this.builder = GatewayOuterClass.EvaluateDecisionRequest.newBuilder();
    }

    @Override
    public EvaluateDecisionCommandStep1.EvaluateDecisionCommandStep2 decisionId(String decisionId) {
        this.builder.setDecisionId(decisionId);
        return this;
    }

    @Override
    public EvaluateDecisionCommandStep1.EvaluateDecisionCommandStep2 decisionKey(long decisionKey) {
        this.builder.setDecisionKey(decisionKey);
        return this;
    }

    @Override
    public EvaluateDecisionCommandStep1.EvaluateDecisionCommandStep2 variables(InputStream variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.jsonMapper.validateJson("variables", variables));
    }

    @Override
    public EvaluateDecisionCommandStep1.EvaluateDecisionCommandStep2 variables(String variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(variables);
    }

    @Override
    public EvaluateDecisionCommandStep1.EvaluateDecisionCommandStep2 variables(Map<String, Object> variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.jsonMapper.toJson(variables));
    }

    @Override
    public EvaluateDecisionCommandStep1.EvaluateDecisionCommandStep2 variables(Object variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.jsonMapper.toJson(variables));
    }

    @Override
    public FinalCommandStep<EvaluateDecisionResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<EvaluateDecisionResponse> send() {
        GatewayOuterClass.EvaluateDecisionRequest request = this.builder.build();
        RetriableClientFutureImpl<EvaluateDecisionResponse, GatewayOuterClass.EvaluateDecisionResponse> future = new RetriableClientFutureImpl<EvaluateDecisionResponse, GatewayOuterClass.EvaluateDecisionResponse>(gatewayResponse -> new EvaluateDecisionResponseImpl(this.jsonMapper, (GatewayOuterClass.EvaluateDecisionResponse)gatewayResponse), this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.EvaluateDecisionResponse>)streamObserver));
        this.send(request, future);
        return future;
    }

    private void send(GatewayOuterClass.EvaluateDecisionRequest request, StreamObserver<GatewayOuterClass.EvaluateDecisionResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).evaluateDecision(request, streamObserver);
    }

    private EvaluateDecisionCommandStep1.EvaluateDecisionCommandStep2 setVariables(String jsonDocument) {
        this.builder.setVariables(jsonDocument);
        return this;
    }
}

