/*
 * Zeebe REST API
 * API for communicating with the Zeebe cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.zeebe.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Provides information on a partition within a broker node.
 */
@JsonPropertyOrder({
  Partition.JSON_PROPERTY_PARTITION_ID,
  Partition.JSON_PROPERTY_ROLE,
  Partition.JSON_PROPERTY_HEALTH
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-03T11:40:38.552819393Z[GMT]", comments = "Generator version: 7.4.0")
public class Partition {
  public static final String JSON_PROPERTY_PARTITION_ID = "partitionId";
  private Integer partitionId;

  /**
   * Describes the Raft role of the broker for a given partition.
   */
  public enum RoleEnum {
    LEADER("leader"),
    
    FOLLOWER("follower"),
    
    INACTIVE("inactive"),
    
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    RoleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RoleEnum fromValue(String value) {
      for (RoleEnum b : RoleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_ROLE = "role";
  private RoleEnum role;

  /**
   * Describes the current health of the partition.
   */
  public enum HealthEnum {
    HEALTHY("healthy"),
    
    UNHEALTHY("unhealthy"),
    
    DEAD("dead"),
    
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    HealthEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static HealthEnum fromValue(String value) {
      for (HealthEnum b : HealthEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  public static final String JSON_PROPERTY_HEALTH = "health";
  private HealthEnum health;

  public Partition() {
  }

  public Partition partitionId(Integer partitionId) {
    
    this.partitionId = partitionId;
    return this;
  }

   /**
   * The unique ID of this partition.
   * @return partitionId
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARTITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPartitionId() {
    return partitionId;
  }


  @JsonProperty(JSON_PROPERTY_PARTITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartitionId(Integer partitionId) {
    this.partitionId = partitionId;
  }


  public Partition role(RoleEnum role) {
    
    this.role = role;
    return this;
  }

   /**
   * Describes the Raft role of the broker for a given partition.
   * @return role
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ROLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RoleEnum getRole() {
    return role;
  }


  @JsonProperty(JSON_PROPERTY_ROLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRole(RoleEnum role) {
    this.role = role;
  }


  public Partition health(HealthEnum health) {
    
    this.health = health;
    return this;
  }

   /**
   * Describes the current health of the partition.
   * @return health
  **/
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HEALTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public HealthEnum getHealth() {
    return health;
  }


  @JsonProperty(JSON_PROPERTY_HEALTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHealth(HealthEnum health) {
    this.health = health;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Partition partition = (Partition) o;
    return Objects.equals(this.partitionId, partition.partitionId) &&
        Objects.equals(this.role, partition.role) &&
        Objects.equals(this.health, partition.health);
  }

  @Override
  public int hashCode() {
    return Objects.hash(partitionId, role, health);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Partition {\n");
    sb.append("    partitionId: ").append(toIndentedString(partitionId)).append("\n");
    sb.append("    role: ").append(toIndentedString(role)).append("\n");
    sb.append("    health: ").append(toIndentedString(health)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `partitionId` to the URL query string
    if (getPartitionId() != null) {
      try {
        joiner.add(String.format("%spartitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPartitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `role` to the URL query string
    if (getRole() != null) {
      try {
        joiner.add(String.format("%srole%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRole()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `health` to the URL query string
    if (getHealth() != null) {
      try {
        joiner.add(String.format("%shealth%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHealth()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

