/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import io.camunda.zeebe.client.api.response.PartitionBrokerHealth;
import io.camunda.zeebe.client.api.response.PartitionBrokerRole;
import io.camunda.zeebe.client.api.response.PartitionInfo;
import io.camunda.zeebe.client.protocol.rest.Partition;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.Arrays;
import java.util.Objects;

public class PartitionInfoImpl
implements PartitionInfo {
    private final int partitionId;
    private final PartitionBrokerRole role;
    private final PartitionBrokerHealth partitionBrokerHealth;

    public PartitionInfoImpl(GatewayOuterClass.Partition partition) {
        this.partitionId = partition.getPartitionId();
        if (partition.getRole() == GatewayOuterClass.Partition.PartitionBrokerRole.LEADER) {
            this.role = PartitionBrokerRole.LEADER;
        } else if (partition.getRole() == GatewayOuterClass.Partition.PartitionBrokerRole.FOLLOWER) {
            this.role = PartitionBrokerRole.FOLLOWER;
        } else if (partition.getRole() == GatewayOuterClass.Partition.PartitionBrokerRole.INACTIVE) {
            this.role = PartitionBrokerRole.INACTIVE;
        } else {
            throw new RuntimeException(String.format("Unexpected partition broker role %s, should be one of %s", partition.getRole(), Arrays.toString((Object[])PartitionBrokerRole.values())));
        }
        if (partition.getHealth() == GatewayOuterClass.Partition.PartitionBrokerHealth.HEALTHY) {
            this.partitionBrokerHealth = PartitionBrokerHealth.HEALTHY;
        } else if (partition.getHealth() == GatewayOuterClass.Partition.PartitionBrokerHealth.UNHEALTHY) {
            this.partitionBrokerHealth = PartitionBrokerHealth.UNHEALTHY;
        } else if (partition.getHealth() == GatewayOuterClass.Partition.PartitionBrokerHealth.DEAD) {
            this.partitionBrokerHealth = PartitionBrokerHealth.DEAD;
        } else {
            throw new RuntimeException(String.format("Unexpected partition broker health %s, should be one of %s", partition.getHealth(), Arrays.toString((Object[])PartitionBrokerHealth.values())));
        }
    }

    public PartitionInfoImpl(Partition httpPartition) {
        if (httpPartition.getPartitionId() == null) {
            throw new RuntimeException("Unexpected missing partition ID. A partition ID is required.");
        }
        this.partitionId = httpPartition.getPartitionId();
        if (httpPartition.getRole() == Partition.RoleEnum.LEADER) {
            this.role = PartitionBrokerRole.LEADER;
        } else if (httpPartition.getRole() == Partition.RoleEnum.FOLLOWER) {
            this.role = PartitionBrokerRole.FOLLOWER;
        } else if (httpPartition.getRole() == Partition.RoleEnum.INACTIVE) {
            this.role = PartitionBrokerRole.INACTIVE;
        } else {
            throw new RuntimeException(String.format("Unexpected partition broker role %s, should be one of %s", new Object[]{httpPartition.getRole(), Arrays.toString((Object[])PartitionBrokerRole.values())}));
        }
        if (httpPartition.getHealth() == Partition.HealthEnum.HEALTHY) {
            this.partitionBrokerHealth = PartitionBrokerHealth.HEALTHY;
        } else if (httpPartition.getHealth() == Partition.HealthEnum.UNHEALTHY) {
            this.partitionBrokerHealth = PartitionBrokerHealth.UNHEALTHY;
        } else if (httpPartition.getHealth() == Partition.HealthEnum.DEAD) {
            this.partitionBrokerHealth = PartitionBrokerHealth.DEAD;
        } else {
            throw new RuntimeException(String.format("Unexpected partition broker health %s, should be one of %s", new Object[]{httpPartition.getHealth(), Arrays.toString((Object[])PartitionBrokerHealth.values())}));
        }
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public PartitionBrokerRole getRole() {
        return this.role;
    }

    @Override
    public boolean isLeader() {
        return this.role == PartitionBrokerRole.LEADER;
    }

    @Override
    public PartitionBrokerHealth getHealth() {
        return this.partitionBrokerHealth;
    }

    public String toString() {
        return "PartitionInfoImpl{partitionId=" + this.partitionId + ", role=" + (Object)((Object)this.role) + ", health=" + (Object)((Object)this.partitionBrokerHealth) + '}';
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitionId, this.role, this.partitionBrokerHealth});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionInfoImpl that = (PartitionInfoImpl)o;
        return this.partitionId == that.partitionId && this.role == that.role && this.partitionBrokerHealth == that.partitionBrokerHealth;
    }
}

