/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl.rocksdb.transaction;

import io.camunda.zeebe.db.ConsistencyChecksSettings;
import io.camunda.zeebe.db.ContainsForeignKeys;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.ZeebeDbInconsistentException;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.ZeebeDbConstants;
import io.camunda.zeebe.db.impl.rocksdb.transaction.ZeebeTransaction;
import io.camunda.zeebe.db.impl.rocksdb.transaction.ZeebeTransactionDb;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.nio.ByteBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.rocksdb.RocksIterator;

public final class ForeignKeyChecker {
    private final ZeebeTransactionDb<?> transactionDb;
    private final ExpandableArrayBuffer keyBuffer = new ExpandableArrayBuffer();
    private final boolean enabled;

    public ForeignKeyChecker(ZeebeTransactionDb<?> transactionDb, ConsistencyChecksSettings settings) {
        this.transactionDb = transactionDb;
        this.enabled = settings.enableForeignKeyChecks();
    }

    public void assertExists(ZeebeTransaction transaction, ContainsForeignKeys containsForeignKey) throws Exception {
        if (!this.enabled) {
            return;
        }
        for (DbForeignKey<DbKey> fk : containsForeignKey.containedForeignKeys()) {
            this.assertForeignKeyExists(transaction, fk);
        }
    }

    private void assertForeignKeyExists(ZeebeTransaction transaction, DbForeignKey<DbKey> foreignKey) throws Exception {
        if (foreignKey.shouldSkipCheck()) {
            return;
        }
        this.keyBuffer.putLong(0, (long)foreignKey.columnFamily().ordinal(), ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        foreignKey.write((MutableDirectBuffer)this.keyBuffer, 8);
        int keyBufferLength = 8 + foreignKey.getLength();
        switch (foreignKey.match()) {
            case Full: {
                this.assertKeyExists(transaction, foreignKey, this.keyBuffer.byteArray(), keyBufferLength);
                break;
            }
            case Prefix: {
                this.assertPrefixExists(transaction, foreignKey, this.keyBuffer.byteArray(), keyBufferLength);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown foreign key match type: " + foreignKey.match());
            }
        }
    }

    private void assertKeyExists(ZeebeTransaction transaction, DbForeignKey<? extends DbKey> foreignKey, byte[] key, int keyLength) throws Exception {
        boolean exists;
        boolean bl = exists = transaction.get(this.transactionDb.getDefaultNativeHandle(), this.transactionDb.getReadOptionsNativeHandle(), key, keyLength) != null;
        if (!exists) {
            throw new ZeebeDbInconsistentException("Foreign key " + foreignKey.inner() + " does not exist in " + foreignKey.columnFamily());
        }
    }

    private void assertPrefixExists(ZeebeTransaction transaction, DbForeignKey<? extends DbKey> foreignKey, byte[] prefix, int prefixLength) {
        try (RocksIterator iterator = transaction.newIterator(this.transactionDb.getPrefixReadOptions(), this.transactionDb.getDefaultHandle());){
            ByteBuffer bufferView = ByteBuffer.wrap(prefix, 0, prefixLength);
            iterator.seek(bufferView);
            boolean exists = false;
            if (iterator.isValid()) {
                byte[] keyBytes = iterator.key();
                exists = BufferUtil.startsWith((byte[])prefix, (int)0, (int)prefixLength, (byte[])keyBytes, (int)0, (int)keyBytes.length);
            }
            if (!exists) {
                throw new ZeebeDbInconsistentException("Foreign key " + foreignKey.inner() + " does not exist as prefix in " + foreignKey.columnFamily());
            }
        }
    }
}

