/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl;

import io.camunda.zeebe.db.ContainsForeignKeys;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbString;
import java.util.Collection;
import java.util.Collections;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public record DbTenantAwareKey<WrappedKey extends DbKey>(DbString tenantKey, WrappedKey wrappedKey, PlacementType placementType) implements DbKey,
ContainsForeignKeys
{
    public void wrap(DirectBuffer buffer, int offset, int length) {
        switch (this.placementType.ordinal()) {
            case 0: {
                this.tenantKey.wrap(buffer, offset, length);
                int tenantKeyLength = this.tenantKey.getLength();
                this.wrappedKey.wrap(buffer, offset + tenantKeyLength, length - tenantKeyLength);
                break;
            }
            case 1: {
                this.wrappedKey.wrap(buffer, offset, length);
                int wrappedKeyLength = this.wrappedKey.getLength();
                this.tenantKey.wrap(buffer, offset + wrappedKeyLength, length - wrappedKeyLength);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.placementType));
            }
        }
    }

    public int getLength() {
        return this.wrappedKey.getLength() + this.tenantKey.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        switch (this.placementType.ordinal()) {
            case 0: {
                this.tenantKey.write(buffer, offset);
                int tenantKeyLength = this.tenantKey.getLength();
                this.wrappedKey.write(buffer, offset + tenantKeyLength);
                break;
            }
            case 1: {
                this.wrappedKey.write(buffer, offset);
                int wrappedKeyLength = this.wrappedKey.getLength();
                this.tenantKey.write(buffer, offset + wrappedKeyLength);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.placementType));
            }
        }
    }

    @Override
    public Collection<DbForeignKey<DbKey>> containedForeignKeys() {
        if (this.wrappedKey instanceof ContainsForeignKeys) {
            return ((ContainsForeignKeys)this.wrappedKey).containedForeignKeys();
        }
        return Collections.emptyList();
    }

    public static enum PlacementType {
        PREFIX,
        SUFFIX;

    }
}

