/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl.rocksdb;

import io.camunda.zeebe.snapshots.ChecksumProvider;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import org.rocksdb.LiveFileMetaData;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class ChecksumProviderRocksDBImpl
implements ChecksumProvider {
    public Map<String, Long> getSnapshotChecksums(Path snapshotPath) {
        Map<String, Long> map;
        block8: {
            RocksDB db = RocksDB.openReadOnly((String)snapshotPath.toString());
            try {
                map = db.getLiveFilesMetaData().stream().filter(fileMetaData -> fileMetaData.fileChecksum().length != 0).collect(Collectors.toMap(this::getMetadataName, this::rocksDBChecksumAsLong));
                if (db == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (db != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new RuntimeException(e);
                }
            }
            db.close();
        }
        return map;
    }

    private String getMetadataName(LiveFileMetaData fileMetaData) {
        return fileMetaData.fileName().substring(1);
    }

    private Long rocksDBChecksumAsLong(LiveFileMetaData fileMetaData) {
        byte[] checksum = fileMetaData.fileChecksum();
        return Integer.toUnsignedLong(ByteBuffer.wrap(checksum).order(ByteOrder.BIG_ENDIAN).getInt());
    }
}

