/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.log;

import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.util.Either;
import java.util.Collections;
import java.util.List;

@FunctionalInterface
public interface LogStreamWriter {
    default public boolean canWriteEvents(int eventCount, int batchSize) {
        return true;
    }

    default public Either<WriteFailure, Long> tryWrite(LogAppendEntry appendEntry) {
        return this.tryWrite(appendEntry, -1L);
    }

    default public Either<WriteFailure, Long> tryWrite(LogAppendEntry appendEntry, long sourcePosition) {
        return this.tryWrite(Collections.singletonList(appendEntry), sourcePosition);
    }

    default public Either<WriteFailure, Long> tryWrite(List<LogAppendEntry> appendEntries) {
        return this.tryWrite(appendEntries, -1L);
    }

    public Either<WriteFailure, Long> tryWrite(List<LogAppendEntry> var1, long var2);

    public static enum WriteFailure {
        CLOSED,
        FULL,
        INVALID_ARGUMENT;

    }
}

