/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.netflix.concurrency.limits.Limiter;
import io.camunda.zeebe.logstreams.impl.flowcontrol.AppendErrorHandler;
import io.camunda.zeebe.logstreams.impl.flowcontrol.AppenderMetrics;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.prometheus.client.Histogram;

public final class InFlightAppend
implements LogStorage.AppendListener {
    private final AppendErrorHandler errorHandler;
    private final Limiter.Listener limiter;
    private final AppenderMetrics metrics;
    private Histogram.Timer writeTimer;
    private Histogram.Timer commitTimer;
    private long position;

    public InFlightAppend(AppendErrorHandler errorHandler, Limiter.Listener limiter, AppenderMetrics metrics) {
        this.errorHandler = errorHandler;
        this.limiter = limiter;
        this.metrics = metrics;
    }

    @Override
    public void onWrite(long address) {
        this.writeTimer.close();
        this.metrics.setLastWrittenPosition(this.position);
    }

    @Override
    public void onWriteError(Throwable error) {
        this.errorHandler.onWriteError(error);
        this.metrics.decreaseInflight();
        if (this.writeTimer != null) {
            this.writeTimer.close();
        }
        if (this.commitTimer != null) {
            this.commitTimer.close();
        }
        this.limiter.onDropped();
    }

    @Override
    public void onCommit(long address) {
        this.metrics.decreaseInflight();
        this.metrics.setLastCommittedPosition(this.position);
        if (this.commitTimer != null) {
            this.commitTimer.close();
        }
        this.limiter.onSuccess();
    }

    @Override
    public void onCommitError(long address, Throwable error) {
        this.errorHandler.onCommitError(error);
        this.metrics.decreaseInflight();
        this.limiter.onDropped();
    }

    public InFlightAppend start(long position) {
        this.position = position;
        this.writeTimer = this.metrics.startWriteTimer();
        this.commitTimer = this.metrics.startCommitTimer();
        this.metrics.increaseInflight();
        this.metrics.increaseTriedAppends();
        return this;
    }

    public void discard() {
        this.limiter.onIgnore();
    }
}

