/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.msgpack.value;

import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.msgpack.value.BaseValue;
import io.camunda.zeebe.msgpack.value.StringValue;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class EnumValue<E extends Enum<E>>
extends BaseValue {
    private final StringValue decodedValue = new StringValue();
    private E value;
    private final Class<E> klass;

    public EnumValue(Class<E> e, E defaultValue) {
        this.klass = e;
        this.value = defaultValue;
        if (this.value != null) {
            this.decodedValue.wrap(((Enum)this.value).toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    public EnumValue(Class<E> e) {
        this(e, null);
    }

    public E getValue() {
        return this.value;
    }

    public void setValue(E val) {
        this.decodedValue.wrap(((Enum)val).toString().getBytes(StandardCharsets.UTF_8));
        this.value = val;
    }

    @Override
    public void reset() {
        this.decodedValue.reset();
        this.value = null;
    }

    @Override
    public void writeJSON(StringBuilder builder) {
        this.decodedValue.writeJSON(builder);
    }

    @Override
    public void write(MsgPackWriter writer) {
        this.decodedValue.write(writer);
    }

    @Override
    public void read(MsgPackReader reader) {
        this.decodedValue.read(reader);
        this.value = Enum.valueOf(this.klass, this.decodedValue.toString());
    }

    @Override
    public int getEncodedLength() {
        return this.decodedValue.getEncodedLength();
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EnumValue) {
            EnumValue enumValue = (EnumValue)o;
            return Objects.equals(this.getValue(), enumValue.getValue());
        }
        return false;
    }
}

