/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.Engine;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.processing.EngineProcessors;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.JobStreamer;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorContext;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBuilder;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.engine.CommandSender;
import io.camunda.zeebe.process.test.engine.CommandWriter;
import io.camunda.zeebe.process.test.engine.EngineStateMonitor;
import io.camunda.zeebe.process.test.engine.GatewayRequestStore;
import io.camunda.zeebe.process.test.engine.GrpcResponseWriter;
import io.camunda.zeebe.process.test.engine.GrpcToLogStreamGateway;
import io.camunda.zeebe.process.test.engine.InMemoryEngine;
import io.camunda.zeebe.process.test.engine.InMemoryJobStreamer;
import io.camunda.zeebe.process.test.engine.InMemoryLogStorage;
import io.camunda.zeebe.process.test.engine.RecordStreamSourceImpl;
import io.camunda.zeebe.process.test.engine.db.InMemoryDbFactory;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.clock.ControlledActorClock;
import io.camunda.zeebe.stream.api.CommandResponseWriter;
import io.camunda.zeebe.stream.api.InterPartitionCommandSender;
import io.camunda.zeebe.stream.impl.StreamProcessor;
import io.camunda.zeebe.util.FeatureFlags;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class EngineFactory {
    public static ZeebeTestEngine create() {
        return EngineFactory.create(EngineFactory.findFreePort());
    }

    private static int findFreePort() {
        int freePort;
        try (ServerSocket serverSocket = new ServerSocket(0);){
            freePort = serverSocket.getLocalPort();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return freePort;
    }

    public static ZeebeTestEngine create(Consumer<Intent> requestListener) {
        return EngineFactory.create(EngineFactory.findFreePort(), requestListener);
    }

    public static ZeebeTestEngine create(int port) {
        return EngineFactory.create(port, null);
    }

    private static ZeebeTestEngine create(int port, Consumer<Intent> requestListener) {
        boolean partitionId = true;
        boolean partitionCount = true;
        ControlledActorClock clock = EngineFactory.createActorClock();
        ActorScheduler scheduler = EngineFactory.createAndStartActorScheduler((ActorClock)clock);
        InMemoryLogStorage logStorage = new InMemoryLogStorage();
        LogStream logStream = EngineFactory.createLogStream(logStorage, (ActorSchedulingService)scheduler, 1);
        CommandWriter commandWriter = new CommandWriter((LogStreamWriter)logStream.newLogStreamWriter().join());
        CommandSender commandSender = new CommandSender(commandWriter);
        GatewayRequestStore gatewayRequestStore = new GatewayRequestStore();
        InMemoryJobStreamer jobStreamer = new InMemoryJobStreamer(commandWriter);
        GrpcToLogStreamGateway gateway = new GrpcToLogStreamGateway(commandWriter, 1, 1, port, gatewayRequestStore, jobStreamer);
        Server grpcServer = ServerBuilder.forPort((int)port).addService((BindableService)gateway).build();
        GrpcResponseWriter grpcResponseWriter = new GrpcResponseWriter(gateway, gatewayRequestStore, requestListener);
        ZeebeDb<ZbColumnFamilies> zeebeDb = EngineFactory.createDatabase();
        StreamProcessor streamProcessor = EngineFactory.createStreamProcessor(logStream, zeebeDb, (ActorSchedulingService)scheduler, grpcResponseWriter, 1, commandSender, jobStreamer);
        EngineStateMonitor engineStateMonitor = new EngineStateMonitor(logStorage, streamProcessor);
        LogStreamReader reader = (LogStreamReader)logStream.newLogStreamReader().join();
        RecordStreamSourceImpl recordStream = new RecordStreamSourceImpl(reader, 1);
        return new InMemoryEngine(grpcServer, streamProcessor, gateway, zeebeDb, logStream, scheduler, recordStream, clock, engineStateMonitor);
    }

    private static ControlledActorClock createActorClock() {
        return new ControlledActorClock();
    }

    private static ActorScheduler createAndStartActorScheduler(ActorClock clock) {
        ActorScheduler scheduler = ActorScheduler.newActorScheduler().setActorClock(clock).build();
        scheduler.start();
        return scheduler;
    }

    private static LogStream createLogStream(LogStorage logStorage, ActorSchedulingService scheduler, int partitionId) {
        LogStreamBuilder builder = LogStream.builder().withPartitionId(partitionId).withLogStorage(logStorage).withActorSchedulingService(scheduler);
        CompletableFuture theFuture = new CompletableFuture();
        scheduler.submitActor(Actor.wrap(control -> builder.buildAsync().onComplete((logStream, failure) -> {
            if (failure != null) {
                theFuture.completeExceptionally((Throwable)failure);
            } else {
                theFuture.complete(logStream);
            }
        })));
        return (LogStream)theFuture.join();
    }

    private static ZeebeDb<ZbColumnFamilies> createDatabase() {
        InMemoryDbFactory factory = new InMemoryDbFactory();
        return factory.createDb();
    }

    private static StreamProcessor createStreamProcessor(LogStream logStream, ZeebeDb<ZbColumnFamilies> database, ActorSchedulingService scheduler, GrpcResponseWriter grpcResponseWriter, int partitionCount, CommandSender commandSender, JobStreamer jobStreamer) {
        return StreamProcessor.builder().logStream(logStream).zeebeDb(database).commandResponseWriter((CommandResponseWriter)grpcResponseWriter).partitionCommandSender((InterPartitionCommandSender)commandSender).recordProcessors(List.of(new Engine(context -> EngineProcessors.createEngineProcessors((TypedRecordProcessorContext)context, (int)partitionCount, (SubscriptionCommandSender)new SubscriptionCommandSender(context.getPartitionId(), (InterPartitionCommandSender)commandSender), (InterPartitionCommandSender)commandSender, (FeatureFlags)FeatureFlags.createDefault(), (JobStreamer)jobStreamer), new EngineConfiguration()))).actorSchedulingService(scheduler).build();
    }
}

