/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.extension.testcontainer;

import io.camunda.zeebe.process.test.extension.testcontainer.ContainerProperties;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public final class EngineContainer
extends GenericContainer<EngineContainer> {
    private static final Logger LOG = LoggerFactory.getLogger((String)"io.camunda.zeebe-process-test");
    private static EngineContainer INSTANCE;

    private EngineContainer(String imageName) {
        super(DockerImageName.parse((String)imageName));
    }

    public static EngineContainer getContainer() {
        if (INSTANCE == null) {
            EngineContainer.createContainer();
        }
        return INSTANCE;
    }

    private static void createContainer() {
        INSTANCE = (EngineContainer)((EngineContainer)((EngineContainer)new EngineContainer(ContainerProperties.getDockerImageName()).withExposedPorts(new Integer[]{ContainerProperties.getContainerPort(), ContainerProperties.getGatewayPort()})).withLogConsumer((Consumer)new Slf4jLogConsumer(LOG))).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*ZeebeProcessTestEngine container has started.*", (int)1));
    }
}

