/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.filters.logger;

import io.camunda.zeebe.process.test.api.RecordStreamSource;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.value.CommandDistributionRecordValue;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.ErrorRecordValue;
import io.camunda.zeebe.protocol.record.value.EscalationRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageStartEventSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessEventRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceResultRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.ResourceDeletionRecordValue;
import io.camunda.zeebe.protocol.record.value.SignalRecordValue;
import io.camunda.zeebe.protocol.record.value.SignalSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordStreamLogger {
    private static final Logger LOG = LoggerFactory.getLogger(RecordStreamLogger.class);
    private final RecordStream recordStream;
    private final Map<ValueType, Function<Record<?>, String>> valueTypeLoggers = new HashMap();

    public RecordStreamLogger(RecordStreamSource recordStreamSource) {
        this.recordStream = RecordStream.of(recordStreamSource);
        this.valueTypeLoggers.put(ValueType.JOB, this::logJobRecordValue);
        this.valueTypeLoggers.put(ValueType.DEPLOYMENT, this::logDeploymentRecordValue);
        this.valueTypeLoggers.put(ValueType.PROCESS_INSTANCE, this::logProcessInstanceRecordValue);
        this.valueTypeLoggers.put(ValueType.INCIDENT, this::logIncidentRecordValue);
        this.valueTypeLoggers.put(ValueType.MESSAGE, this::logMessageRecordValue);
        this.valueTypeLoggers.put(ValueType.MESSAGE_SUBSCRIPTION, this::logMessageSubscriptionRecordValue);
        this.valueTypeLoggers.put(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, this::logProcessMessageSubscriptionRecordValue);
        this.valueTypeLoggers.put(ValueType.JOB_BATCH, this::logJobBatchRecordValue);
        this.valueTypeLoggers.put(ValueType.TIMER, this::logTimerRecordValue);
        this.valueTypeLoggers.put(ValueType.MESSAGE_START_EVENT_SUBSCRIPTION, this::logMessageStartEventSubscriptionRecordValue);
        this.valueTypeLoggers.put(ValueType.VARIABLE, this::logVariableRecordValue);
        this.valueTypeLoggers.put(ValueType.VARIABLE_DOCUMENT, this::logVariableDocumentRecordValue);
        this.valueTypeLoggers.put(ValueType.PROCESS_INSTANCE_CREATION, this::logProcessInstanceCreationRecordValue);
        this.valueTypeLoggers.put(ValueType.ERROR, this::logErrorRecordValue);
        this.valueTypeLoggers.put(ValueType.PROCESS_INSTANCE_RESULT, this::logProcessInstanceResultRecordValue);
        this.valueTypeLoggers.put(ValueType.PROCESS, this::logProcessRecordValue);
        this.valueTypeLoggers.put(ValueType.PROCESS_EVENT, this::logProcessEventRecordValue);
        this.valueTypeLoggers.put(ValueType.ESCALATION, this::logEscalationRecordValue);
        this.valueTypeLoggers.put(ValueType.DEPLOYMENT_DISTRIBUTION, record -> "");
        this.valueTypeLoggers.put(ValueType.SBE_UNKNOWN, record -> "");
        this.valueTypeLoggers.put(ValueType.NULL_VAL, record -> "");
        this.valueTypeLoggers.put(ValueType.DECISION, record -> "");
        this.valueTypeLoggers.put(ValueType.DECISION_REQUIREMENTS, record -> "");
        this.valueTypeLoggers.put(ValueType.DECISION_EVALUATION, record -> "");
        this.valueTypeLoggers.put(ValueType.CHECKPOINT, record -> "");
        this.valueTypeLoggers.put(ValueType.PROCESS_INSTANCE_MODIFICATION, this::logProcessInstanceModificationRecordValue);
        this.valueTypeLoggers.put(ValueType.SIGNAL_SUBSCRIPTION, this::logSignalSubscriptionRecordValue);
        this.valueTypeLoggers.put(ValueType.SIGNAL, this::logSignalRecordValue);
        this.valueTypeLoggers.put(ValueType.RESOURCE_DELETION, this::logResourceDeletionRecordValue);
        this.valueTypeLoggers.put(ValueType.COMMAND_DISTRIBUTION, this::logCommandDistributionRecordValue);
        this.valueTypeLoggers.put(ValueType.PROCESS_INSTANCE_BATCH, record -> "");
    }

    public void log() {
        StringBuilder stringBuilder = new StringBuilder().append(System.lineSeparator());
        this.logRecords(stringBuilder);
    }

    private void logRecords(StringBuilder stringBuilder) {
        stringBuilder.append("The following records have been recorded during this test:");
        this.recordStream.records().forEach(record -> stringBuilder.append(this.logRecord((Record<?>)record)));
        LOG.info(stringBuilder.toString());
    }

    protected String logRecord(Record<?> record) {
        return this.logGenericRecord(record) + this.logRecordDetails(record);
    }

    private String logGenericRecord(Record<?> record) {
        return System.lineSeparator() + String.format("| %-20s", record.getRecordType()) + String.format("%-35s", record.getValueType()) + String.format("%-30s| ", record.getIntent());
    }

    private String logRecordDetails(Record<?> record) {
        return this.valueTypeLoggers.getOrDefault(record.getValueType(), var -> "").apply(record);
    }

    private String logJobRecordValue(Record<?> record) {
        JobRecordValue value = (JobRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        if (record.getRecordType().equals((Object)RecordType.EVENT)) {
            joiner.add(String.format("(Element id: %s)", value.getElementId()));
            joiner.add(String.format("(Job type: %s)", value.getType()));
            if (!value.getVariables().isEmpty()) {
                joiner.add(this.logVariables(value.getVariables()));
            }
        }
        return joiner.toString();
    }

    private String logDeploymentRecordValue(Record<?> record) {
        DeploymentRecordValue value = (DeploymentRecordValue)record.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        if (!value.getResources().isEmpty()) {
            StringJoiner joiner = new StringJoiner(", ", "[", "]");
            value.getResources().forEach(resource -> joiner.add(resource.getResourceName()));
            stringBuilder.append(String.format("(Processes: %s)", joiner));
        }
        return stringBuilder.toString();
    }

    private String logProcessInstanceRecordValue(Record<?> record) {
        ProcessInstanceRecordValue value = (ProcessInstanceRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Element id: %s)", value.getElementId()));
        joiner.add(String.format("(Element type: %s)", value.getBpmnElementType()));
        joiner.add(String.format("(Event type: %s)", value.getBpmnEventType()));
        joiner.add(String.format("(Process id: %s)", value.getBpmnProcessId()));
        return joiner.toString();
    }

    private String logIncidentRecordValue(Record<?> record) {
        IncidentRecordValue value = (IncidentRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        if (record.getRecordType().equals((Object)RecordType.EVENT)) {
            joiner.add(String.format("(Element id: %s)", value.getElementId()));
            joiner.add(String.format("(Process id: %s)", value.getBpmnProcessId()));
        }
        return joiner.toString();
    }

    private String logMessageRecordValue(Record<?> record) {
        MessageRecordValue value = (MessageRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Message name: %s)", value.getName()));
        joiner.add(String.format("(Correlation key: %s)", value.getCorrelationKey()));
        joiner.add(this.logVariables(value.getVariables()));
        return joiner.toString();
    }

    private String logMessageSubscriptionRecordValue(Record<?> record) {
        MessageSubscriptionRecordValue value = (MessageSubscriptionRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Message name: %s)", value.getMessageName()));
        joiner.add(String.format("(Correlation key: %s)", value.getCorrelationKey()));
        joiner.add(this.logVariables(value.getVariables()));
        return joiner.toString();
    }

    private String logProcessMessageSubscriptionRecordValue(Record<?> record) {
        ProcessMessageSubscriptionRecordValue value = (ProcessMessageSubscriptionRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Message name: %s)", value.getMessageName()));
        if (record.getRecordType().equals((Object)RecordType.EVENT)) {
            joiner.add(String.format("(Correlation key: %s)", value.getCorrelationKey()));
            joiner.add(String.format("(Element id: %s)", value.getElementId()));
        }
        joiner.add(this.logVariables(value.getVariables()));
        return joiner.toString();
    }

    private String logJobBatchRecordValue(Record<?> record) {
        JobBatchRecordValue value = (JobBatchRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Worker: %s)", value.getWorker()));
        joiner.add(String.format("(Job type: %s)", value.getType()));
        return joiner.toString();
    }

    private String logTimerRecordValue(Record<?> record) {
        TimerRecordValue value = (TimerRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Element id: %s)", value.getTargetElementId()));
        joiner.add(String.format("(Due date: %s)", new Date(value.getDueDate())));
        return joiner.toString();
    }

    private String logMessageStartEventSubscriptionRecordValue(Record<?> record) {
        MessageStartEventSubscriptionRecordValue value = (MessageStartEventSubscriptionRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Process id: %s)", value.getBpmnProcessId()));
        joiner.add(String.format("(Start event id: %s)", value.getStartEventId()));
        joiner.add(String.format("(Message name: %s)", value.getMessageName()));
        joiner.add(String.format("(Correlation key: %s)", value.getCorrelationKey()));
        return joiner.toString();
    }

    private String logVariableRecordValue(Record<?> record) {
        VariableRecordValue value = (VariableRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Name: %s)", value.getName()));
        joiner.add(String.format("(Value: %s)", value.getValue()));
        return joiner.toString();
    }

    private String logVariableDocumentRecordValue(Record<?> record) {
        VariableDocumentRecordValue value = (VariableDocumentRecordValue)record.getValue();
        return this.logVariables(value.getVariables());
    }

    private String logProcessInstanceCreationRecordValue(Record<?> record) {
        ProcessInstanceCreationRecordValue value = (ProcessInstanceCreationRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Process id: %s)", value.getBpmnProcessId()));
        if (!value.getVariables().isEmpty()) {
            joiner.add(this.logVariables(value.getVariables()));
        }
        joiner.add(this.logStartInstructions(value.getStartInstructions()));
        return joiner.toString();
    }

    private String logErrorRecordValue(Record<?> record) {
        ErrorRecordValue value = (ErrorRecordValue)record.getValue();
        return String.format("(Exception message: %s)", value.getExceptionMessage());
    }

    private String logProcessInstanceResultRecordValue(Record<?> record) {
        ProcessInstanceResultRecordValue value = (ProcessInstanceResultRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Process id: %s)", value.getBpmnProcessId()));
        joiner.add(this.logVariables(value.getVariables()));
        return joiner.toString();
    }

    private String logProcessRecordValue(Record<?> record) {
        ProcessMetadataValue value = (ProcessMetadataValue)record.getValue();
        return String.format("(Process: %s)", value.getResourceName());
    }

    private String logProcessEventRecordValue(Record<?> record) {
        ProcessEventRecordValue value = (ProcessEventRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Target element id: %s)", value.getTargetElementId()));
        joiner.add(this.logVariables(value.getVariables()));
        return joiner.toString();
    }

    private String logEscalationRecordValue(Record<?> record) {
        EscalationRecordValue value = (EscalationRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Process id: %s)", value.getProcessInstanceKey()));
        joiner.add(String.format("(Escalation code: %s)", value.getEscalationCode()));
        joiner.add(String.format("(Throw element id: %s)", value.getThrowElementId()));
        joiner.add(String.format("(Catch element id: %s)", value.getCatchElementId()));
        return joiner.toString();
    }

    private String logProcessInstanceModificationRecordValue(Record<?> record) {
        ProcessInstanceModificationRecordValue value = (ProcessInstanceModificationRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Target process instance: %d)", value.getProcessInstanceKey()));
        joiner.add(this.logActivateInstructions(value.getActivateInstructions()));
        joiner.add(this.logTerminateInstructions(value.getTerminateInstructions()));
        return joiner.toString();
    }

    protected String logVariables(Map<String, Object> variables) {
        if (variables.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        variables.forEach((key, value) -> joiner.add(key + " -> " + value));
        return String.format("(Variables: %s)", joiner);
    }

    private String logStartInstructions(List<ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue> startInstructions) {
        if (startInstructions.isEmpty()) {
            return "(default start)";
        }
        return startInstructions.stream().map(ProcessInstanceCreationRecordValue.ProcessInstanceCreationStartInstructionValue::getElementId).collect(Collectors.joining(", ", "(starting before elements: ", ")"));
    }

    private String logActivateInstructions(List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> instructions) {
        if (instructions.isEmpty()) {
            return "(no activate)";
        }
        return instructions.stream().map(this::logActivateInstruction).collect(Collectors.joining(", ", "(activating elements: ", ")"));
    }

    private String logActivateInstruction(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue instruction) {
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Target element id: %s)", instruction.getElementId()));
        joiner.add(String.format("(Ancestor scope key: %d)", instruction.getAncestorScopeKey()));
        joiner.add(this.logVariableInstructions(instruction.getVariableInstructions()));
        return joiner.toString();
    }

    private String logVariableInstructions(List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> variables) {
        if (variables.isEmpty()) {
            return "(no variables)";
        }
        return variables.stream().map(this::logVariableInstruction).collect(Collectors.joining(", ", "(with variable instruction: ", ")"));
    }

    private String logVariableInstruction(ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue variable) {
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Target element: %s", variable.getElementId()));
        joiner.add(this.logVariables(variable.getVariables()));
        return joiner.toString();
    }

    private String logTerminateInstructions(List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> instructions) {
        if (instructions.isEmpty()) {
            return "(no terminate)";
        }
        return instructions.stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue::getElementInstanceKey).map(String::valueOf).collect(Collectors.joining(", ", "(terminating elements: ", ")"));
    }

    private String logSignalSubscriptionRecordValue(Record<?> record) {
        SignalSubscriptionRecordValue value = (SignalSubscriptionRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Process id: %s)", value.getBpmnProcessId()));
        joiner.add(String.format("(Catch event id: %s)", value.getCatchEventId()));
        joiner.add(String.format("(Signal name: %s)", value.getSignalName()));
        joiner.add(String.format("(Catch event instance key: %s)", value.getCatchEventInstanceKey()));
        return joiner.toString();
    }

    private String logSignalRecordValue(Record<?> record) {
        SignalRecordValue value = (SignalRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(Signal name: %s)", value.getSignalName()));
        joiner.add(this.logVariables(value.getVariables()));
        return joiner.toString();
    }

    private String logResourceDeletionRecordValue(Record<?> record) {
        ResourceDeletionRecordValue value = (ResourceDeletionRecordValue)record.getValue();
        return String.format("(Resource key: %d", value.getResourceKey());
    }

    private String logCommandDistributionRecordValue(Record<?> record) {
        CommandDistributionRecordValue value = (CommandDistributionRecordValue)record.getValue();
        StringJoiner joiner = new StringJoiner(", ", "", "");
        joiner.add(String.format("(To partition id: %d)", value.getPartitionId()));
        joiner.add(String.format("(Value type: %s)", value.getValueType()));
        return joiner.toString();
    }

    protected Map<ValueType, Function<Record<?>, String>> getValueTypeLoggers() {
        return this.valueTypeLoggers;
    }
}

