/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.filters;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class IncidentRecordStreamFilter {
    private final Stream<Record<IncidentRecordValue>> stream;

    public IncidentRecordStreamFilter(Iterable<Record<IncidentRecordValue>> records) {
        this.stream = StreamSupport.stream(records.spliterator(), false);
    }

    public IncidentRecordStreamFilter(Stream<Record<IncidentRecordValue>> stream) {
        this.stream = stream;
    }

    public IncidentRecordStreamFilter withIncidentKey(long incidentKey) {
        return new IncidentRecordStreamFilter(this.stream.filter(record -> record.getKey() == incidentKey));
    }

    public IncidentRecordStreamFilter withRejectionType(RejectionType rejectionType) {
        return new IncidentRecordStreamFilter(this.stream.filter(record -> record.getRejectionType() == rejectionType));
    }

    public IncidentRecordStreamFilter withProcessInstanceKey(long processInstanceKey) {
        return new IncidentRecordStreamFilter(this.stream.filter(record -> ((IncidentRecordValue)record.getValue()).getProcessInstanceKey() == processInstanceKey));
    }

    public IncidentRecordStreamFilter withJobKey(long jobKey) {
        return new IncidentRecordStreamFilter(this.stream.filter(record -> ((IncidentRecordValue)record.getValue()).getJobKey() == jobKey));
    }

    public IncidentRecordStreamFilter withIntent(IncidentIntent intent) {
        return new IncidentRecordStreamFilter(this.stream.filter(record -> record.getIntent() == intent));
    }

    public Stream<Record<IncidentRecordValue>> stream() {
        return this.stream;
    }
}

