/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.filters;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ProcessMessageSubscriptionRecordStreamFilter {
    private final Stream<Record<ProcessMessageSubscriptionRecordValue>> stream;

    public ProcessMessageSubscriptionRecordStreamFilter(Iterable<Record<ProcessMessageSubscriptionRecordValue>> records) {
        this.stream = StreamSupport.stream(records.spliterator(), false);
    }

    public ProcessMessageSubscriptionRecordStreamFilter(Stream<Record<ProcessMessageSubscriptionRecordValue>> stream) {
        this.stream = stream;
    }

    public ProcessMessageSubscriptionRecordStreamFilter withProcessInstanceKey(long processInstanceKey) {
        return new ProcessMessageSubscriptionRecordStreamFilter(this.stream.filter(record -> ((ProcessMessageSubscriptionRecordValue)record.getValue()).getProcessInstanceKey() == processInstanceKey));
    }

    public ProcessMessageSubscriptionRecordStreamFilter withMessageName(String messageName) {
        return new ProcessMessageSubscriptionRecordStreamFilter(this.stream.filter(record -> ((ProcessMessageSubscriptionRecordValue)record.getValue()).getMessageName().equals(messageName)));
    }

    public ProcessMessageSubscriptionRecordStreamFilter withCorrelationKey(String correlationKey) {
        return new ProcessMessageSubscriptionRecordStreamFilter(this.stream.filter(record -> ((ProcessMessageSubscriptionRecordValue)record.getValue()).getCorrelationKey().equals(correlationKey)));
    }

    public ProcessMessageSubscriptionRecordStreamFilter withRejectionType(RejectionType rejectionType) {
        return new ProcessMessageSubscriptionRecordStreamFilter(this.stream.filter(record -> record.getRejectionType() == rejectionType));
    }

    public ProcessMessageSubscriptionRecordStreamFilter withIntent(ProcessMessageSubscriptionIntent intent) {
        return new ProcessMessageSubscriptionRecordStreamFilter(this.stream.filter(record -> record.getIntent() == intent));
    }

    public ProcessMessageSubscriptionRecordStreamFilter withMessageKey(long messageKey) {
        return new ProcessMessageSubscriptionRecordStreamFilter(this.stream.filter(record -> ((ProcessMessageSubscriptionRecordValue)record.getValue()).getMessageKey() == messageKey));
    }

    public Stream<Record<ProcessMessageSubscriptionRecordValue>> stream() {
        return this.stream;
    }
}

