/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.filters;

import io.camunda.zeebe.process.test.api.RecordStreamSource;
import io.camunda.zeebe.process.test.filters.logger.IncidentLogger;
import io.camunda.zeebe.process.test.filters.logger.RecordStreamLogger;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageStartEventSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.FormMetadataValue;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordStream {
    private static final Logger LOG = LoggerFactory.getLogger((String)"io.camunda.zeebe.process.test");
    private final RecordStreamSource recordStreamSource;

    private RecordStream(RecordStreamSource recordStreamSource) {
        this.recordStreamSource = recordStreamSource;
    }

    public static RecordStream of(RecordStreamSource recordStreamSource) {
        return new RecordStream(recordStreamSource);
    }

    public Iterable<Record<?>> records() {
        return this.recordStreamSource.getRecords();
    }

    <T extends RecordValue> Iterable<Record<T>> recordsOfValueType(ValueType valueType) {
        Stream<Record> stream = StreamSupport.stream(this.recordStreamSource.getRecords().spliterator(), false).filter(record -> record.getValueType() == valueType);
        return stream::iterator;
    }

    public Iterable<Record<ProcessInstanceRecordValue>> processInstanceRecords() {
        return this.recordsOfValueType(ValueType.PROCESS_INSTANCE);
    }

    public Iterable<Record<JobRecordValue>> jobRecords() {
        return this.recordsOfValueType(ValueType.JOB);
    }

    public Iterable<Record<JobBatchRecordValue>> jobBatchRecords() {
        return this.recordsOfValueType(ValueType.JOB_BATCH);
    }

    public Iterable<Record<DeploymentRecordValue>> deploymentRecords() {
        return this.recordsOfValueType(ValueType.DEPLOYMENT);
    }

    public Iterable<Record<Process>> processRecords() {
        return this.recordsOfValueType(ValueType.PROCESS);
    }

    public Iterable<Record<VariableRecordValue>> variableRecords() {
        return this.recordsOfValueType(ValueType.VARIABLE);
    }

    public Iterable<Record<VariableDocumentRecordValue>> variableDocumentRecords() {
        return this.recordsOfValueType(ValueType.VARIABLE_DOCUMENT);
    }

    public Iterable<Record<IncidentRecordValue>> incidentRecords() {
        return this.recordsOfValueType(ValueType.INCIDENT);
    }

    public Iterable<Record<TimerRecordValue>> timerRecords() {
        return this.recordsOfValueType(ValueType.TIMER);
    }

    public Iterable<Record<MessageRecordValue>> messageRecords() {
        return this.recordsOfValueType(ValueType.MESSAGE);
    }

    public Iterable<Record<MessageBatchRecordValue>> messageBatchRecords() {
        return this.recordsOfValueType(ValueType.MESSAGE_BATCH);
    }

    public Iterable<Record<MessageSubscriptionRecordValue>> messageSubscriptionRecords() {
        return this.recordsOfValueType(ValueType.MESSAGE_SUBSCRIPTION);
    }

    public Iterable<Record<MessageStartEventSubscriptionRecordValue>> messageStartEventSubscriptionRecords() {
        return this.recordsOfValueType(ValueType.MESSAGE_START_EVENT_SUBSCRIPTION);
    }

    public Iterable<Record<ProcessMessageSubscriptionRecordValue>> processMessageSubscriptionRecords() {
        return this.recordsOfValueType(ValueType.PROCESS_MESSAGE_SUBSCRIPTION);
    }

    public Iterable<Record<FormMetadataValue>> forms() {
        return this.recordsOfValueType(ValueType.FORM);
    }

    public void print(boolean compact) {
        if (compact) {
            new IncidentLogger(this.recordStreamSource).log();
            new RecordStreamLogger(this.recordStreamSource).log();
        } else {
            LOG.info("===== records (count: ${count()}) =====");
            this.recordStreamSource.getRecords().forEach(record -> LOG.info(record.toJson()));
            LOG.info("---------------------------");
        }
    }
}

