/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.filters.logger;

import io.camunda.zeebe.process.test.api.RecordStreamSource;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.process.test.filters.StreamFilter;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncidentLogger {
    private static final Logger LOG = LoggerFactory.getLogger(IncidentLogger.class);
    private final RecordStream recordStream;

    public IncidentLogger(RecordStreamSource recordStreamSource) {
        this.recordStream = RecordStream.of(recordStreamSource);
    }

    public void log() {
        StringBuilder stringBuilder = new StringBuilder();
        this.logIncidents(stringBuilder);
        LOG.info(stringBuilder.toString());
    }

    private void logIncidents(StringBuilder stringBuilder) {
        Set resolvedIncidents = StreamFilter.incident(this.recordStream).withIntent(IncidentIntent.RESOLVED).stream().map(Record::getKey).collect(Collectors.toSet());
        List<Record> createIncidents = StreamFilter.incident(this.recordStream).withIntent(IncidentIntent.CREATED).stream().filter(record -> !resolvedIncidents.contains(record.getKey())).collect(Collectors.toList());
        if (!createIncidents.isEmpty()) {
            stringBuilder.append(System.lineSeparator()).append(System.lineSeparator()).append("Unresolved incident(s) exist at the end of this test").append(System.lineSeparator());
            createIncidents.forEach(record -> {
                if (!resolvedIncidents.contains(record.getKey())) {
                    stringBuilder.append(this.summarizeIncident((Record<IncidentRecordValue>)record)).append(System.lineSeparator());
                }
            });
            stringBuilder.append(System.lineSeparator()).append("If you did not expect any incidents to occur, then we recommend investigatingthese. These incidents may indicate what went wrong in your test case").append(System.lineSeparator());
        }
    }

    private String summarizeIncident(Record<IncidentRecordValue> incident) {
        IncidentRecordValue value = (IncidentRecordValue)incident.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("On element %s in process %s", value.getElementId(), value.getBpmnProcessId())).append(System.lineSeparator()).append("\t").append("- Error type: ").append(value.getErrorType()).append(System.lineSeparator()).append("\t").append("- Error message: ").append(value.getErrorMessage());
        return stringBuilder.toString();
    }
}

