/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.filters;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.record.value.MessageStartEventSubscriptionRecordValue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class MessageStartEventSubscriptionStreamFilter {
    private final Stream<Record<MessageStartEventSubscriptionRecordValue>> stream;

    public MessageStartEventSubscriptionStreamFilter(Iterable<Record<MessageStartEventSubscriptionRecordValue>> records) {
        this.stream = StreamSupport.stream(records.spliterator(), false);
    }

    public MessageStartEventSubscriptionStreamFilter(Stream<Record<MessageStartEventSubscriptionRecordValue>> stream) {
        this.stream = stream;
    }

    public MessageStartEventSubscriptionStreamFilter withMessageKey(long messageKey) {
        return new MessageStartEventSubscriptionStreamFilter(this.stream.filter(record -> ((MessageStartEventSubscriptionRecordValue)record.getValue()).getMessageKey() == messageKey));
    }

    public MessageStartEventSubscriptionStreamFilter withRejectionType(RejectionType rejectionType) {
        return new MessageStartEventSubscriptionStreamFilter(this.stream.filter(record -> record.getRejectionType() == rejectionType));
    }

    public MessageStartEventSubscriptionStreamFilter withIntent(MessageStartEventSubscriptionIntent intent) {
        return new MessageStartEventSubscriptionStreamFilter(this.stream.filter(record -> record.getIntent() == intent));
    }

    public Stream<Record<MessageStartEventSubscriptionRecordValue>> stream() {
        return this.stream;
    }
}

