/*
 * Copyright © 2021 camunda services GmbH (info@camunda.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.camunda.zeebe.process.test.filters;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class TimerRecordStreamFilter {

  private final Stream<Record<TimerRecordValue>> stream;

  public TimerRecordStreamFilter(final Iterable<Record<TimerRecordValue>> records) {
    stream = StreamSupport.stream(records.spliterator(), false);
  }

  public TimerRecordStreamFilter(final Stream<Record<TimerRecordValue>> stream) {
    this.stream = stream;
  }

  public TimerRecordStreamFilter withIntent(final TimerIntent intent) {
    return new TimerRecordStreamFilter(stream.filter(record -> record.getIntent() == intent));
  }

  public Stream<Record<TimerRecordValue>> stream() {
    return stream;
  }
}
