/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.filters;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.ProcessEventIntent;
import io.camunda.zeebe.protocol.record.value.ProcessEventRecordValue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ProcessEventRecordStreamFilter {
    private final Stream<Record<ProcessEventRecordValue>> stream;

    public ProcessEventRecordStreamFilter(Iterable<Record<?>> records) {
        this.stream = StreamSupport.stream(records.spliterator(), true).filter(record -> record.getValueType() == ValueType.PROCESS_EVENT).map(record -> record);
    }

    public ProcessEventRecordStreamFilter(Stream<Record<ProcessEventRecordValue>> stream) {
        this.stream = stream;
    }

    public ProcessEventRecordStreamFilter withIntent(ProcessEventIntent intent) {
        return new ProcessEventRecordStreamFilter(this.stream.filter(record -> record.getIntent() == intent));
    }

    public ProcessEventRecordStreamFilter withTargetElementId(String targetElementId) {
        return new ProcessEventRecordStreamFilter(this.stream.filter(record -> ((ProcessEventRecordValue)record.getValue()).getTargetElementId().equals(targetElementId)));
    }

    public ProcessEventRecordStreamFilter withProcessDefinitionKey(long processDefinitionKey) {
        return new ProcessEventRecordStreamFilter(this.stream.filter(record -> ((ProcessEventRecordValue)record.getValue()).getProcessDefinitionKey() == processDefinitionKey));
    }

    public Stream<Record<ProcessEventRecordValue>> stream() {
        return this.stream;
    }
}

