/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.filters;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import java.util.Arrays;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ProcessInstanceRecordStreamFilter {
    private final Stream<Record<ProcessInstanceRecordValue>> stream;

    public ProcessInstanceRecordStreamFilter(Iterable<Record<ProcessInstanceRecordValue>> records) {
        this.stream = StreamSupport.stream(records.spliterator(), false);
    }

    public ProcessInstanceRecordStreamFilter(Stream<Record<ProcessInstanceRecordValue>> stream) {
        this.stream = stream;
    }

    public ProcessInstanceRecordStreamFilter withProcessInstanceKey(long processInstanceKey) {
        return new ProcessInstanceRecordStreamFilter(this.stream.filter(record -> ((ProcessInstanceRecordValue)record.getValue()).getProcessInstanceKey() == processInstanceKey));
    }

    public ProcessInstanceRecordStreamFilter withBpmnElementType(BpmnElementType bpmnElementType) {
        return new ProcessInstanceRecordStreamFilter(this.stream.filter(record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType() == bpmnElementType));
    }

    public ProcessInstanceRecordStreamFilter withoutBpmnElementType(BpmnElementType bpmnElementType) {
        return new ProcessInstanceRecordStreamFilter(this.stream.filter(record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnElementType() != bpmnElementType));
    }

    public ProcessInstanceRecordStreamFilter withBpmnEventType(BpmnEventType bpmnEventType) {
        return new ProcessInstanceRecordStreamFilter(this.stream.filter(record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnEventType() == bpmnEventType));
    }

    public ProcessInstanceRecordStreamFilter withoutBpmnEventType(BpmnEventType bpmnEventType) {
        return new ProcessInstanceRecordStreamFilter(this.stream.filter(record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnEventType() != bpmnEventType));
    }

    public ProcessInstanceRecordStreamFilter withIntent(ProcessInstanceIntent intent) {
        return new ProcessInstanceRecordStreamFilter(this.stream.filter(record -> record.getIntent() == intent));
    }

    public ProcessInstanceRecordStreamFilter withIntents(ProcessInstanceIntent ... intents) {
        return new ProcessInstanceRecordStreamFilter(this.stream.filter(record -> Arrays.stream(intents).anyMatch(intent -> record.getIntent() == intent)));
    }

    public ProcessInstanceRecordStreamFilter withElementId(String elementId) {
        return new ProcessInstanceRecordStreamFilter(this.stream.filter(record -> ((ProcessInstanceRecordValue)record.getValue()).getElementId().equals(elementId)));
    }

    public ProcessInstanceRecordStreamFilter withElementIdIn(String ... elementIds) {
        return new ProcessInstanceRecordStreamFilter(this.stream.filter(record -> Arrays.asList(elementIds).contains(((ProcessInstanceRecordValue)record.getValue()).getElementId())));
    }

    public ProcessInstanceRecordStreamFilter withRejectionType(RejectionType rejectionType) {
        return new ProcessInstanceRecordStreamFilter(this.stream.filter(record -> record.getRejectionType() == rejectionType));
    }

    public ProcessInstanceRecordStreamFilter withParentProcessInstanceKey(long parentProcessInstanceKey) {
        return new ProcessInstanceRecordStreamFilter(this.stream.filter(record -> ((ProcessInstanceRecordValue)record.getValue()).getParentProcessInstanceKey() == parentProcessInstanceKey));
    }

    public ProcessInstanceRecordStreamFilter withBpmnProcessId(String bpmnProcessId) {
        return new ProcessInstanceRecordStreamFilter(this.stream.filter(record -> ((ProcessInstanceRecordValue)record.getValue()).getBpmnProcessId().equals(bpmnProcessId)));
    }

    public ProcessInstanceRecordStreamFilter withRecordType(RecordType recordType) {
        return new ProcessInstanceRecordStreamFilter(this.stream.filter(record -> record.getRecordType() == recordType));
    }

    public Stream<Record<ProcessInstanceRecordValue>> stream() {
        return this.stream;
    }
}

