/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.decision;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.spec.MsgPackHelper;
import io.camunda.zeebe.msgpack.value.BaseValue;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.decision.EvaluatedDecisionRecord;
import io.camunda.zeebe.protocol.record.value.DecisionEvaluationRecordValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedDecisionValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class DecisionEvaluationRecord
extends UnifiedRecordValue
implements DecisionEvaluationRecordValue {
    private static final DirectBuffer NIL_VALUE = BufferUtil.wrapArray((byte[])MsgPackHelper.NIL);
    private final LongProperty decisionKeyProp = new LongProperty("decisionKey", -1L);
    private final StringProperty decisionIdProp = new StringProperty("decisionId", "");
    private final StringProperty decisionNameProp = new StringProperty("decisionName", "");
    private final IntegerProperty decisionVersionProp = new IntegerProperty("decisionVersion", -1);
    private final StringProperty decisionRequirementsIdProp = new StringProperty("decisionRequirementsId", "");
    private final LongProperty decisionRequirementsKeyProp = new LongProperty("decisionRequirementsKey", -1L);
    private final BinaryProperty decisionOutputProp = new BinaryProperty("decisionOutput", NIL_VALUE);
    private final DocumentProperty variablesProp = new DocumentProperty("variables");
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final LongProperty processDefinitionKeyProp = new LongProperty("processDefinitionKey", -1L);
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey", -1L);
    private final StringProperty elementIdProp = new StringProperty("elementId", "");
    private final LongProperty elementInstanceKeyProp = new LongProperty("elementInstanceKey", -1L);
    private final ArrayProperty<EvaluatedDecisionRecord> evaluatedDecisionsProp = new ArrayProperty("evaluatedDecisions", (BaseValue)new EvaluatedDecisionRecord());
    private final StringProperty evaluationFailureMessageProp = new StringProperty("evaluationFailureMessage", "");
    private final StringProperty failedDecisionIdProp = new StringProperty("failedDecisionId", "");
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");

    public DecisionEvaluationRecord() {
        this.declareProperty((BaseProperty)this.decisionKeyProp).declareProperty((BaseProperty)this.decisionIdProp).declareProperty((BaseProperty)this.decisionNameProp).declareProperty((BaseProperty)this.decisionVersionProp).declareProperty((BaseProperty)this.decisionRequirementsIdProp).declareProperty((BaseProperty)this.decisionRequirementsKeyProp).declareProperty((BaseProperty)this.decisionOutputProp).declareProperty((BaseProperty)this.variablesProp).declareProperty((BaseProperty)this.bpmnProcessIdProp).declareProperty((BaseProperty)this.processDefinitionKeyProp).declareProperty((BaseProperty)this.processInstanceKeyProp).declareProperty((BaseProperty)this.elementIdProp).declareProperty((BaseProperty)this.elementInstanceKeyProp).declareProperty(this.evaluatedDecisionsProp).declareProperty((BaseProperty)this.evaluationFailureMessageProp).declareProperty((BaseProperty)this.failedDecisionIdProp).declareProperty((BaseProperty)this.tenantIdProp);
    }

    public long getDecisionKey() {
        return this.decisionKeyProp.getValue();
    }

    public DecisionEvaluationRecord setDecisionKey(long decisionKey) {
        this.decisionKeyProp.setValue(decisionKey);
        return this;
    }

    public String getDecisionId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.decisionIdProp.getValue());
    }

    public DecisionEvaluationRecord setDecisionId(String decisionId) {
        this.decisionIdProp.setValue(decisionId);
        return this;
    }

    public DecisionEvaluationRecord setDecisionId(DirectBuffer decisionId) {
        this.decisionIdProp.setValue(decisionId);
        return this;
    }

    public String getDecisionName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.decisionNameProp.getValue());
    }

    public DecisionEvaluationRecord setDecisionName(String decisionName) {
        this.decisionNameProp.setValue(decisionName);
        return this;
    }

    public DecisionEvaluationRecord setDecisionName(DirectBuffer decisionName) {
        this.decisionNameProp.setValue(decisionName);
        return this;
    }

    public int getDecisionVersion() {
        return this.decisionVersionProp.getValue();
    }

    public DecisionEvaluationRecord setDecisionVersion(int decisionVersion) {
        this.decisionVersionProp.setValue(decisionVersion);
        return this;
    }

    public String getDecisionRequirementsId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.decisionRequirementsIdProp.getValue());
    }

    public DecisionEvaluationRecord setDecisionRequirementsId(String decisionRequirementsId) {
        this.decisionRequirementsIdProp.setValue(decisionRequirementsId);
        return this;
    }

    public DecisionEvaluationRecord setDecisionRequirementsId(DirectBuffer decisionRequirementsId) {
        this.decisionRequirementsIdProp.setValue(decisionRequirementsId);
        return this;
    }

    public long getDecisionRequirementsKey() {
        return this.decisionRequirementsKeyProp.getValue();
    }

    public DecisionEvaluationRecord setDecisionRequirementsKey(long decisionRequirementsKey) {
        this.decisionRequirementsKeyProp.setValue(decisionRequirementsKey);
        return this;
    }

    public String getDecisionOutput() {
        return MsgPackConverter.convertToJson(this.decisionOutputProp.getValue());
    }

    public DecisionEvaluationRecord setDecisionOutput(DirectBuffer decisionOutput) {
        this.decisionOutputProp.setValue(decisionOutput);
        return this;
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProp.getValue());
    }

    public DecisionEvaluationRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public DecisionEvaluationRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProp.getValue();
    }

    public DecisionEvaluationRecord setProcessDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKeyProp.setValue(processDefinitionKey);
        return this;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public DecisionEvaluationRecord setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKeyProp.setValue(processInstanceKey);
        return this;
    }

    public String getElementId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.elementIdProp.getValue());
    }

    public DecisionEvaluationRecord setElementId(String elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    public DecisionEvaluationRecord setElementId(DirectBuffer elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKeyProp.getValue();
    }

    public DecisionEvaluationRecord setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKeyProp.setValue(elementInstanceKey);
        return this;
    }

    public List<EvaluatedDecisionValue> getEvaluatedDecisions() {
        ArrayList<EvaluatedDecisionValue> evaluatedDecisions = new ArrayList<EvaluatedDecisionValue>();
        for (EvaluatedDecisionRecord evaluatedDecision : this.evaluatedDecisionsProp) {
            EvaluatedDecisionRecord copyRecord = new EvaluatedDecisionRecord();
            DirectBuffer copyBuffer = BufferUtil.createCopy((BufferWriter)evaluatedDecision);
            copyRecord.wrap(copyBuffer);
            evaluatedDecisions.add(copyRecord);
        }
        return evaluatedDecisions;
    }

    public String getEvaluationFailureMessage() {
        return BufferUtil.bufferAsString((DirectBuffer)this.evaluationFailureMessageProp.getValue());
    }

    public String getFailedDecisionId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.failedDecisionIdProp.getValue());
    }

    public DecisionEvaluationRecord setFailedDecisionId(String failedDecisionId) {
        this.failedDecisionIdProp.setValue(failedDecisionId);
        return this;
    }

    public DecisionEvaluationRecord setEvaluationFailureMessage(String evaluationFailureMessage) {
        this.evaluationFailureMessageProp.setValue(evaluationFailureMessage);
        return this;
    }

    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProp.getValue());
    }

    public DecisionEvaluationRecord setVariables(DirectBuffer variables) {
        this.variablesProp.setValue(variables);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getEvaluationFailureMessageBuffer() {
        return this.evaluationFailureMessageProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getFailedDecisionIdBuffer() {
        return this.failedDecisionIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getDecisionOutputBuffer() {
        return this.decisionOutputProp.getValue();
    }

    @JsonIgnore
    public ValueArray<EvaluatedDecisionRecord> evaluatedDecisions() {
        return this.evaluatedDecisionsProp;
    }

    @JsonIgnore
    public DirectBuffer getDecisionRequirementsIdBuffer() {
        return this.decisionRequirementsIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getElementIdBuffer() {
        return this.elementIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getDecisionIdBuffer() {
        return this.decisionIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getDecisionNameBuffer() {
        return this.decisionNameProp.getValue();
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProp.getValue());
    }

    public DecisionEvaluationRecord setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }
}

