/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.deployment;

import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.value.BaseValue;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsMetadataRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormMetadataRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsMetadataValue;
import io.camunda.zeebe.protocol.record.value.deployment.FormMetadataValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import java.util.List;
import org.agrona.DirectBuffer;

public final class DeploymentRecord
extends UnifiedRecordValue
implements DeploymentRecordValue {
    public static final String RESOURCES = "resources";
    public static final String PROCESSES = "processesMetadata";
    private final ArrayProperty<DeploymentResource> resourcesProp = new ArrayProperty("resources", (BaseValue)new DeploymentResource());
    private final ArrayProperty<ProcessMetadata> processesMetadataProp = new ArrayProperty("processesMetadata", (BaseValue)new ProcessMetadata());
    private final ArrayProperty<DecisionRecord> decisionMetadataProp = new ArrayProperty("decisionsMetadata", (BaseValue)new DecisionRecord());
    private final ArrayProperty<DecisionRequirementsMetadataRecord> decisionRequirementsMetadataProp = new ArrayProperty("decisionRequirementsMetadata", (BaseValue)new DecisionRequirementsMetadataRecord());
    private final ArrayProperty<FormMetadataRecord> formMetadataProp = new ArrayProperty("formMetadata", (BaseValue)new FormMetadataRecord());
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");

    public DeploymentRecord() {
        this.declareProperty((BaseProperty)this.resourcesProp).declareProperty(this.processesMetadataProp).declareProperty(this.decisionRequirementsMetadataProp).declareProperty(this.decisionMetadataProp).declareProperty(this.formMetadataProp).declareProperty((BaseProperty)this.tenantIdProp);
    }

    public ValueArray<ProcessMetadata> processesMetadata() {
        return this.processesMetadataProp;
    }

    public ValueArray<DeploymentResource> resources() {
        return this.resourcesProp;
    }

    public ValueArray<DecisionRecord> decisionsMetadata() {
        return this.decisionMetadataProp;
    }

    public ValueArray<DecisionRequirementsMetadataRecord> decisionRequirementsMetadata() {
        return this.decisionRequirementsMetadataProp;
    }

    public ValueArray<FormMetadataRecord> formMetadata() {
        return this.formMetadataProp;
    }

    public List<io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource> getResources() {
        ArrayList<io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource> resources = new ArrayList<io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource>();
        for (DeploymentResource resource : this.resourcesProp) {
            DeploymentResource copiedResource = new DeploymentResource();
            DirectBuffer copyBuffer = BufferUtil.createCopy((BufferWriter)resource);
            copiedResource.wrap(copyBuffer);
            resources.add(copiedResource);
        }
        return resources;
    }

    public List<ProcessMetadataValue> getProcessesMetadata() {
        ArrayList<ProcessMetadataValue> processesMeta = new ArrayList<ProcessMetadataValue>();
        for (ProcessMetadata processRecord : this.processesMetadataProp) {
            ProcessMetadata copiedProcessRecord = new ProcessMetadata();
            DirectBuffer copyBuffer = BufferUtil.createCopy((BufferWriter)processRecord);
            copiedProcessRecord.wrap(copyBuffer);
            processesMeta.add(copiedProcessRecord);
        }
        return processesMeta;
    }

    public List<DecisionRecordValue> getDecisionsMetadata() {
        ArrayList<DecisionRecordValue> metadataList = new ArrayList<DecisionRecordValue>();
        for (DecisionRecord metadata : this.decisionMetadataProp) {
            DecisionRecord copyRecord = new DecisionRecord();
            DirectBuffer copyBuffer = BufferUtil.createCopy((BufferWriter)metadata);
            copyRecord.wrap(copyBuffer);
            metadataList.add(copyRecord);
        }
        return metadataList;
    }

    public List<DecisionRequirementsMetadataValue> getDecisionRequirementsMetadata() {
        ArrayList<DecisionRequirementsMetadataValue> metadataList = new ArrayList<DecisionRequirementsMetadataValue>();
        for (DecisionRequirementsMetadataRecord metadata : this.decisionRequirementsMetadataProp) {
            DecisionRequirementsMetadataRecord copyRecord = new DecisionRequirementsMetadataRecord();
            DirectBuffer copyBuffer = BufferUtil.createCopy((BufferWriter)metadata);
            copyRecord.wrap(copyBuffer);
            metadataList.add(copyRecord);
        }
        return metadataList;
    }

    public List<FormMetadataValue> getFormMetadata() {
        ArrayList<FormMetadataValue> metadataList = new ArrayList<FormMetadataValue>();
        for (FormMetadataRecord metadata : this.formMetadataProp) {
            FormMetadataRecord copyRecord = new FormMetadataRecord();
            DirectBuffer copyBuffer = BufferUtil.createCopy((BufferWriter)metadata);
            copyRecord.wrap(copyBuffer);
            metadataList.add(copyRecord);
        }
        return metadataList;
    }

    public void resetResources() {
        this.resourcesProp.reset();
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProp.getValue());
    }

    public DeploymentRecord setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }

    public boolean hasBpmnResources() {
        return this.getResources().stream().map(io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource::getResourceName).anyMatch(x -> x.endsWith(".bpmn") || x.endsWith(".xml"));
    }

    public boolean hasDmnResources() {
        return this.getResources().stream().map(io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource::getResourceName).anyMatch(x -> x.endsWith(".dmn"));
    }
}

